/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.javaclassloader;

import io.opentelemetry.javaagent.bootstrap.HelperResources;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ResourceInjectionInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<? super TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"java.lang.ClassLoader"));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"getResources")).and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{String.class})), ResourceInjectionInstrumentation.class.getName() + "$GetResourcesAdvice");
    }

    public static class GetResourcesAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void onExit(@Advice.This ClassLoader classLoader, @Advice.Argument(value=0) String name, @Advice.Return(readOnly=false) Enumeration<URL> resources) {
            URL helper = HelperResources.load((ClassLoader)classLoader, (String)name);
            if (helper == null) {
                return;
            }
            if (!resources.hasMoreElements()) {
                resources = Collections.enumeration(Collections.singleton(helper));
                return;
            }
            ArrayList<URL> result = Collections.list(resources);
            boolean duplicate = false;
            for (URL loadedUrl : result) {
                if (!helper.sameFile(loadedUrl)) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) {
                result.add(helper);
            }
            resources = Collections.enumeration(result);
        }
    }
}

