/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.cpu;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.DurationUtil;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class LongLockHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME = "jvm.cpu.longlock";
    private static final String METRIC_DESCRIPTION = "Long lock times";
    private static final String EVENT_NAME = "jdk.JavaMonitorWait";
    private final DoubleHistogram histogram;
    private final Attributes attributes;

    public LongLockHandler(Meter meter) {
        this.histogram = meter.histogramBuilder(METRIC_NAME).setDescription(METRIC_DESCRIPTION).setUnit("s").build();
        this.attributes = Attributes.empty();
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.LOCK_METRICS;
    }

    @Override
    public void accept(RecordedEvent recordedEvent) {
        this.histogram.record(DurationUtil.toSeconds(recordedEvent.getDuration()), this.attributes);
    }

    @Override
    public Optional<Duration> getThreshold() {
        return Optional.empty();
    }
}

