/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.stacktrace.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.trace.data.DelegatingSpanData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class MutableSpanData
extends DelegatingSpanData {
    @Nullable
    private Map<AttributeKey<?>, Object> attributeOverrides = null;
    @Nullable
    private Attributes cachedMutatedAttributes = null;
    @Nullable
    private String nameOverride = null;

    protected MutableSpanData(SpanData delegate) {
        super(delegate);
    }

    public <T> void setAttribute(AttributeKey<T> key, @Nullable T value) {
        if (this.attributeOverrides != null && this.attributeOverrides.containsKey(key) && Objects.equals(this.attributeOverrides.get(key), value)) {
            return;
        }
        Object originalValue = super.getAttributes().get(key);
        if (Objects.equals(originalValue, value)) {
            if (this.attributeOverrides != null) {
                this.cachedMutatedAttributes = null;
                this.attributeOverrides.remove(key);
            }
            return;
        }
        if (this.attributeOverrides == null) {
            this.attributeOverrides = new HashMap();
        }
        this.cachedMutatedAttributes = null;
        this.attributeOverrides.put(key, value);
    }

    public Attributes getAttributes() {
        Attributes original = super.getAttributes();
        if (this.attributeOverrides == null || this.attributeOverrides.isEmpty()) {
            return original;
        }
        if (this.cachedMutatedAttributes == null) {
            AttributesBuilder attributesBuilder = Attributes.builder().putAll(original);
            for (AttributeKey<?> overrideKey : this.attributeOverrides.keySet()) {
                Object value = this.attributeOverrides.get(overrideKey);
                if (value == null) {
                    attributesBuilder.remove(overrideKey);
                    continue;
                }
                attributesBuilder.put(overrideKey, value);
            }
            this.cachedMutatedAttributes = attributesBuilder.build();
        }
        return this.cachedMutatedAttributes;
    }

    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        if (this.attributeOverrides != null && this.attributeOverrides.containsKey(key)) {
            return (T)this.attributeOverrides.get(key);
        }
        return (T)super.getAttributes().get(key);
    }

    public void setName(String name) {
        this.nameOverride = name;
    }

    public String getName() {
        if (this.nameOverride != null) {
            return this.nameOverride;
        }
        return super.getName();
    }
}

