/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.stacktrace.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.Arrays;

public abstract class AbstractSimpleChainingSpanProcessor
implements SpanProcessor {
    protected final SpanProcessor next;
    private final boolean nextRequiresStart;
    private final boolean nextRequiresEnd;

    public AbstractSimpleChainingSpanProcessor(SpanProcessor next) {
        this.next = next;
        this.nextRequiresStart = next.isStartRequired();
        this.nextRequiresEnd = next.isEndRequired();
    }

    protected void doOnStart(Context context, ReadWriteSpan readWriteSpan) {
    }

    @CanIgnoreReturnValue
    protected ReadableSpan doOnEnd(ReadableSpan readableSpan) {
        return readableSpan;
    }

    protected boolean requiresStart() {
        return true;
    }

    protected boolean requiresEnd() {
        return true;
    }

    protected CompletableResultCode doForceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    protected CompletableResultCode doShutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public final void onStart(Context context, ReadWriteSpan readWriteSpan) {
        try {
            if (this.requiresStart()) {
                this.doOnStart(context, readWriteSpan);
            }
        }
        finally {
            if (this.nextRequiresStart) {
                this.next.onStart(context, readWriteSpan);
            }
        }
    }

    public final void onEnd(ReadableSpan readableSpan) {
        ReadableSpan mappedTo = readableSpan;
        try {
            if (this.requiresEnd()) {
                mappedTo = this.doOnEnd(readableSpan);
            }
        }
        finally {
            if (mappedTo != null && this.nextRequiresEnd) {
                this.next.onEnd(mappedTo);
            }
        }
    }

    public final boolean isStartRequired() {
        return this.requiresStart() || this.nextRequiresStart;
    }

    public final boolean isEndRequired() {
        return this.requiresEnd() || this.nextRequiresEnd;
    }

    public final CompletableResultCode shutdown() {
        return CompletableResultCode.ofAll(Arrays.asList(this.doShutdown(), this.next.shutdown()));
    }

    public final CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(Arrays.asList(this.doForceFlush(), this.next.forceFlush()));
    }

    public final void close() {
        super.close();
    }
}

