/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.Composable;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentAnyOf
extends ConsistentSampler {
    private final Composable[] delegates;
    private final String description;

    ConsistentAnyOf(Composable ... delegates) {
        if (delegates == null || delegates.length == 0) {
            throw new IllegalArgumentException("At least one delegate must be specified for ConsistentAnyOf");
        }
        this.delegates = delegates;
        this.description = Stream.of(delegates).map(Object::toString).collect(Collectors.joining(",", "ConsistentAnyOf{", "}"));
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        final SamplingIntent[] intents = new SamplingIntent[this.delegates.length];
        long minimumThreshold = ConsistentSamplingUtil.getInvalidThreshold();
        boolean isAdjustedCountCorrect = false;
        int k = 0;
        for (Composable delegate : this.delegates) {
            SamplingIntent delegateIntent = delegate.getSamplingIntent(parentContext, name, spanKind, attributes, parentLinks);
            long delegateThreshold = delegateIntent.getThreshold();
            if (ConsistentSamplingUtil.isValidThreshold(delegateThreshold)) {
                if (ConsistentSamplingUtil.isValidThreshold(minimumThreshold)) {
                    if (delegateThreshold == minimumThreshold) {
                        if (delegateIntent.isAdjustedCountReliable()) {
                            isAdjustedCountCorrect = true;
                        }
                    } else if (delegateThreshold < minimumThreshold) {
                        minimumThreshold = delegateThreshold;
                        isAdjustedCountCorrect = delegateIntent.isAdjustedCountReliable();
                    }
                } else {
                    minimumThreshold = delegateThreshold;
                    isAdjustedCountCorrect = delegateIntent.isAdjustedCountReliable();
                }
            }
            intents[k++] = delegateIntent;
        }
        final long resultingThreshold = minimumThreshold;
        final boolean isResultingAdjustedCountCorrect = isAdjustedCountCorrect;
        return new SamplingIntent(){

            @Override
            public long getThreshold() {
                return resultingThreshold;
            }

            @Override
            public boolean isAdjustedCountReliable() {
                return isResultingAdjustedCountCorrect;
            }

            @Override
            public Attributes getAttributes() {
                AttributesBuilder builder = Attributes.builder();
                for (SamplingIntent intent : intents) {
                    builder = builder.putAll(intent.getAttributes());
                }
                return builder.build();
            }

            @Override
            public TraceState updateTraceState(TraceState previousState) {
                for (SamplingIntent intent : intents) {
                    previousState = intent.updateTraceState(previousState);
                }
                return previousState;
            }
        };
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

