/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.Composable;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import javax.annotation.concurrent.Immutable;

final class ConsistentRateLimitingSampler
extends ConsistentSampler {
    private static final double NANOS_IN_SECONDS = 1.0E-9;
    private final String description;
    private final LongSupplier nanoTimeSupplier;
    private final double inverseAdaptationTimeNanos;
    private final double targetSpansPerNanosecondLimit;
    private final double probabilitySmoothingFactor;
    private final AtomicReference<State> state;
    private final Composable delegate;

    ConsistentRateLimitingSampler(Composable delegate, double targetSpansPerSecondLimit, double adaptationTimeSeconds, LongSupplier nanoTimeSupplier) {
        this.delegate = Objects.requireNonNull(delegate);
        if (targetSpansPerSecondLimit < 0.0) {
            throw new IllegalArgumentException("Limit for sampled spans per second must be nonnegative!");
        }
        if (adaptationTimeSeconds < 0.0) {
            throw new IllegalArgumentException("Adaptation rate must be nonnegative!");
        }
        this.description = "ConsistentRateLimitingSampler{targetSpansPerSecondLimit=" + targetSpansPerSecondLimit + ", adaptationTimeSeconds=" + adaptationTimeSeconds + "}";
        this.nanoTimeSupplier = Objects.requireNonNull(nanoTimeSupplier);
        this.inverseAdaptationTimeNanos = 1.0E-9 / adaptationTimeSeconds;
        this.targetSpansPerNanosecondLimit = 1.0E-9 * targetSpansPerSecondLimit;
        this.probabilitySmoothingFactor = ConsistentRateLimitingSampler.determineProbabilitySmoothingFactor(targetSpansPerSecondLimit, adaptationTimeSeconds);
        this.state = new AtomicReference<State>(new State(0.0, 0.0, nanoTimeSupplier.getAsLong(), 1.0));
    }

    private static double determineProbabilitySmoothingFactor(double targetSpansPerSecondLimit, double adaptationTimeSeconds) {
        double t = 1.0 / (targetSpansPerSecondLimit * adaptationTimeSeconds);
        return t / (1.0 + t);
    }

    private State updateState(State oldState, long currentNanoTime, double delegateProbability) {
        double currentAverageProbability = oldState.effectiveDelegateProbability * (1.0 - this.probabilitySmoothingFactor) + delegateProbability * this.probabilitySmoothingFactor;
        long nanoTimeDelta = currentNanoTime - oldState.lastNanoTime;
        if ((double)nanoTimeDelta <= 0.0) {
            return new State(oldState.effectiveWindowCount + 1.0, oldState.effectiveWindowNanos, oldState.lastNanoTime, currentAverageProbability);
        }
        double decayFactor = Math.exp((double)(-nanoTimeDelta) * this.inverseAdaptationTimeNanos);
        double currentEffectiveWindowCount = oldState.effectiveWindowCount * decayFactor + 1.0;
        double currentEffectiveWindowNanos = oldState.effectiveWindowNanos * decayFactor + (double)nanoTimeDelta;
        return new State(currentEffectiveWindowCount, currentEffectiveWindowNanos, currentNanoTime, currentAverageProbability);
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        long suggestedThreshold;
        final SamplingIntent delegateIntent = this.delegate.getSamplingIntent(parentContext, name, spanKind, attributes, parentLinks);
        long delegateThreshold = delegateIntent.getThreshold();
        if (ConsistentSamplingUtil.isValidThreshold(delegateThreshold)) {
            double delegateProbability = ConsistentSamplingUtil.calculateSamplingProbability(delegateThreshold);
            long currentNanoTime = this.nanoTimeSupplier.getAsLong();
            State currentState = this.state.updateAndGet(s -> this.updateState((State)s, currentNanoTime, delegateProbability));
            double targetMaxProbability = currentState.effectiveWindowNanos * this.targetSpansPerNanosecondLimit / currentState.effectiveWindowCount;
            double suggestedProbability = currentState.effectiveDelegateProbability > targetMaxProbability ? targetMaxProbability / currentState.effectiveDelegateProbability * delegateProbability : delegateProbability;
            suggestedThreshold = ConsistentSamplingUtil.calculateThreshold(suggestedProbability);
        } else {
            suggestedThreshold = ConsistentSamplingUtil.getInvalidThreshold();
        }
        return new SamplingIntent(){

            @Override
            public long getThreshold() {
                return suggestedThreshold;
            }

            @Override
            public boolean isAdjustedCountReliable() {
                return delegateIntent.isAdjustedCountReliable();
            }

            @Override
            public Attributes getAttributes() {
                return delegateIntent.getAttributes();
            }

            @Override
            public TraceState updateTraceState(TraceState previousState) {
                return delegateIntent.updateTraceState(previousState);
            }
        };
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Immutable
    private static final class State {
        private final double effectiveWindowCount;
        private final double effectiveWindowNanos;
        private final double effectiveDelegateProbability;
        private final long lastNanoTime;

        public State(double effectiveWindowCount, double effectiveWindowNanos, long lastNanoTime, double effectiveDelegateProbability) {
            this.effectiveWindowCount = effectiveWindowCount;
            this.effectiveWindowNanos = effectiveWindowNanos;
            this.lastNanoTime = lastNanoTime;
            this.effectiveDelegateProbability = effectiveDelegateProbability;
        }
    }
}

