/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;

public class ConsistentFixedThresholdSampler
extends ConsistentSampler {
    private final long threshold;
    private final String description;

    protected ConsistentFixedThresholdSampler(long threshold) {
        this.threshold = ConsistentFixedThresholdSampler.getThreshold(threshold);
        this.description = ConsistentFixedThresholdSampler.getThresholdDescription(threshold);
    }

    protected ConsistentFixedThresholdSampler(double samplingProbability) {
        this(ConsistentSamplingUtil.calculateThreshold(samplingProbability));
    }

    private static long getThreshold(long threshold) {
        ConsistentSamplingUtil.checkThreshold(threshold);
        return threshold;
    }

    private static String getThresholdDescription(long threshold) {
        String thresholdString = threshold == ConsistentSamplingUtil.getMaxThreshold() ? "max" : ConsistentSamplingUtil.appendLast56BitHexEncodedWithoutTrailingZeros(new StringBuilder(), threshold).toString();
        return "ConsistentFixedThresholdSampler{threshold=" + thresholdString + ", sampling probability=" + ConsistentSamplingUtil.calculateSamplingProbability(threshold) + "}";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return () -> {
            if (this.threshold == ConsistentSamplingUtil.getMaxThreshold()) {
                return ConsistentSamplingUtil.getInvalidThreshold();
            }
            return this.threshold;
        };
    }
}

