/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;

@FunctionalInterface
public interface Predicate {
    public boolean spanMatches(Context var1, String var2, SpanKind var3, Attributes var4, List<LinkData> var5);

    public static Predicate isRootSpan() {
        return (parentContext, name, spanKind, attributes, parentLinks) -> {
            Span parentSpan = Span.fromContext((Context)parentContext);
            SpanContext parentSpanContext = parentSpan.getSpanContext();
            return !parentSpanContext.isValid();
        };
    }

    public static Predicate hasLocalParent() {
        return (parentContext, name, spanKind, attributes, parentLinks) -> {
            Span parentSpan = Span.fromContext((Context)parentContext);
            SpanContext parentSpanContext = parentSpan.getSpanContext();
            return !parentSpanContext.isValid() || !parentSpanContext.isRemote();
        };
    }

    public static Predicate anySpan() {
        return (parentContext, name, spanKind, attributes, parentLinks) -> true;
    }

    public static Predicate and(Predicate p1, Predicate p2) {
        return (parentContext, name, spanKind, attributes, parentLinks) -> p1.spanMatches(parentContext, name, spanKind, attributes, parentLinks) && p2.spanMatches(parentContext, name, spanKind, attributes, parentLinks);
    }

    public static Predicate not(Predicate p) {
        return (parentContext, name, spanKind, attributes, parentLinks) -> !p.spanMatches(parentContext, name, spanKind, attributes, parentLinks);
    }

    public static Predicate or(Predicate p1, Predicate p2) {
        return (parentContext, name, spanKind, attributes, parentLinks) -> p1.spanMatches(parentContext, name, spanKind, attributes, parentLinks) || p2.spanMatches(parentContext, name, spanKind, attributes, parentLinks);
    }
}

