/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent.OtelTraceState;
import io.opentelemetry.contrib.sampler.consistent.RandomGenerator;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.DelegatingSpanData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class ConsistentReservoirSamplingSpanProcessor
implements SpanProcessor {
    private static final String WORKER_THREAD_NAME = ConsistentReservoirSamplingSpanProcessor.class.getSimpleName() + "_WorkerThread";
    private final Worker worker;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    static final long DEFAULT_EXPORT_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(30L);

    private static SpanData updateSpanDataWithOtelTraceState(SpanData spanData, OtelTraceState otelTraceState) {
        SpanContext spanContext = spanData.getSpanContext();
        TraceState traceState = spanContext.getTraceState();
        String updatedOtelTraceStateString = otelTraceState.serialize();
        TraceState updatedTraceState = traceState.toBuilder().put("ot", updatedOtelTraceStateString).build();
        final SpanContext updatedSpanContext = SpanContext.create((String)spanContext.getTraceId(), (String)spanContext.getSpanId(), (TraceFlags)spanContext.getTraceFlags(), (TraceState)updatedTraceState);
        return new DelegatingSpanData(spanData){

            public SpanContext getSpanContext() {
                return updatedSpanContext;
            }
        };
    }

    static SpanProcessor create(SpanExporter spanExporter, int reservoirSize, long exportPeriodNanos, long exporterTimeoutNanos, RandomGenerator randomGenerator) {
        return new ConsistentReservoirSamplingSpanProcessor(spanExporter, exportPeriodNanos, reservoirSize, exporterTimeoutNanos, randomGenerator);
    }

    public static SpanProcessor create(SpanExporter spanExporter, int reservoirSize, long exportPeriodNanos, long exporterTimeoutNanos) {
        return ConsistentReservoirSamplingSpanProcessor.create(spanExporter, reservoirSize, exportPeriodNanos, exporterTimeoutNanos, RandomGenerator.getDefault());
    }

    static SpanProcessor create(SpanExporter spanExporter, int reservoirSize, long exportPeriodNanos) {
        return ConsistentReservoirSamplingSpanProcessor.create(spanExporter, reservoirSize, exportPeriodNanos, DEFAULT_EXPORT_TIMEOUT_NANOS);
    }

    private ConsistentReservoirSamplingSpanProcessor(SpanExporter spanExporter, long exportPeriodNanos, int reservoirSize, long exporterTimeoutNanos, RandomGenerator randomGenerator) {
        Objects.requireNonNull(spanExporter, "spanExporter");
        Utils.checkArgument((exportPeriodNanos > 0L ? 1 : 0) != 0, (String)"export period must be positive");
        Utils.checkArgument((reservoirSize > 0 ? 1 : 0) != 0, (String)"reservoir size must be positive");
        Utils.checkArgument((exporterTimeoutNanos > 0L ? 1 : 0) != 0, (String)"exporter timeout must be positive");
        Objects.requireNonNull(randomGenerator, "randomGenerator");
        this.worker = new Worker(spanExporter, exportPeriodNanos, reservoirSize, exporterTimeoutNanos, randomGenerator);
        Thread workerThread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread((Runnable)this.worker);
        workerThread.start();
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    public boolean isStartRequired() {
        return false;
    }

    public void onEnd(ReadableSpan span) {
        if (span == null || !span.getSpanContext().isSampled()) {
            return;
        }
        this.worker.addSpan(span);
    }

    public boolean isEndRequired() {
        return true;
    }

    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.worker.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.worker.forceFlush();
    }

    boolean isReservoirEmpty() {
        return this.worker.isReservoirEmpty();
    }

    private static final class Worker
    implements Runnable {
        private static final Logger logger = Logger.getLogger(Worker.class.getName());
        private final SpanExporter spanExporter;
        private final long exportPeriodNanos;
        private final int reservoirSize;
        private final long exporterTimeoutNanos;
        private long nextExportTime;
        private final RandomGenerator randomGenerator;
        private final Object reservoirLock = new Object();
        private Reservoir reservoir;
        private final BlockingQueue<CompletableResultCode> signal;
        private volatile boolean continueWork = true;

        private static Reservoir createReservoir(int reservoirSize, RandomGenerator randomGenerator) {
            return new Reservoir(reservoirSize, randomGenerator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Worker(SpanExporter spanExporter, long exportPeriodNanos, int reservoirSize, long exporterTimeoutNanos, RandomGenerator randomGenerator) {
            this.spanExporter = spanExporter;
            this.exportPeriodNanos = exportPeriodNanos;
            this.reservoirSize = reservoirSize;
            this.exporterTimeoutNanos = exporterTimeoutNanos;
            this.randomGenerator = randomGenerator;
            Object object = this.reservoirLock;
            synchronized (object) {
                this.reservoir = Worker.createReservoir(reservoirSize, randomGenerator);
            }
            this.signal = new ArrayBlockingQueue<CompletableResultCode>(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(ReadableSpan span) {
            ReadableSpanWithPriority readableSpanWithPriority = ReadableSpanWithPriority.create(span, this.randomGenerator);
            Object object = this.reservoirLock;
            synchronized (object) {
                this.reservoir.add(readableSpanWithPriority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.updateNextExportTime();
            CompletableResultCode completableResultCode = null;
            while (this.continueWork) {
                if (completableResultCode != null || System.nanoTime() >= this.nextExportTime) {
                    Reservoir oldReservoir;
                    Reservoir newReservoir = Worker.createReservoir(this.reservoirSize, this.randomGenerator);
                    Object object = this.reservoirLock;
                    synchronized (object) {
                        oldReservoir = this.reservoir;
                        this.reservoir = newReservoir;
                    }
                    this.exportCurrentBatch(oldReservoir.getResult());
                    this.updateNextExportTime();
                    if (completableResultCode != null) {
                        completableResultCode.succeed();
                    }
                }
                try {
                    long pollWaitTime = this.nextExportTime - System.nanoTime();
                    if (pollWaitTime <= 0L) continue;
                    completableResultCode = this.signal.poll(pollWaitTime, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private void updateNextExportTime() {
            this.nextExportTime = System.nanoTime() + this.exportPeriodNanos;
        }

        private CompletableResultCode shutdown() {
            CompletableResultCode result = new CompletableResultCode();
            CompletableResultCode flushResult = this.forceFlush();
            flushResult.whenComplete(() -> {
                this.continueWork = false;
                CompletableResultCode shutdownResult = this.spanExporter.shutdown();
                shutdownResult.whenComplete(() -> {
                    if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                        result.fail();
                    } else {
                        result.succeed();
                    }
                });
            });
            return result;
        }

        private CompletableResultCode forceFlush() {
            CompletableResultCode flushResult = new CompletableResultCode();
            this.signal.offer(flushResult);
            return flushResult;
        }

        private void exportCurrentBatch(List<SpanData> batch) {
            if (batch.isEmpty()) {
                return;
            }
            try {
                CompletableResultCode result = this.spanExporter.export(Collections.unmodifiableList(batch));
                result.join(this.exporterTimeoutNanos, TimeUnit.NANOSECONDS);
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exporter threw an Exception", e);
            }
            finally {
                batch.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReservoirEmpty() {
            Object object = this.reservoirLock;
            synchronized (object) {
                return this.reservoir.isEmpty();
            }
        }
    }

    private static final class Reservoir {
        private final int reservoirSize;
        private int maxDiscardedRValue = 0;
        private long numberOfDiscardedSpansWithMaxDiscardedRValue = 0L;
        private final PriorityQueue<ReadableSpanWithPriority> queue;
        private final RandomGenerator randomGenerator;

        public Reservoir(int reservoirSize, RandomGenerator randomGenerator) {
            if (reservoirSize < 1) {
                throw new IllegalArgumentException();
            }
            this.reservoirSize = reservoirSize;
            this.queue = new PriorityQueue(reservoirSize, (x$0, x$1) -> ReadableSpanWithPriority.compareRthenPriority((ReadableSpanWithPriority)x$0, (ReadableSpanWithPriority)x$1));
            this.randomGenerator = randomGenerator;
        }

        public void add(ReadableSpanWithPriority readableSpanWithPriority) {
            if (this.queue.size() < this.reservoirSize) {
                this.queue.add(readableSpanWithPriority);
                return;
            }
            ReadableSpanWithPriority head = this.queue.peek();
            if (ReadableSpanWithPriority.compareRthenPriority(readableSpanWithPriority, head) > 0) {
                this.queue.remove();
                this.queue.add(readableSpanWithPriority);
                readableSpanWithPriority = head;
            }
            if (readableSpanWithPriority.getR() > this.maxDiscardedRValue) {
                this.maxDiscardedRValue = readableSpanWithPriority.getR();
                this.numberOfDiscardedSpansWithMaxDiscardedRValue = 1L;
            } else if (readableSpanWithPriority.getR() == this.maxDiscardedRValue) {
                ++this.numberOfDiscardedSpansWithMaxDiscardedRValue;
            }
        }

        public List<SpanData> getResult() {
            if (this.numberOfDiscardedSpansWithMaxDiscardedRValue == 0L) {
                return this.queue.stream().map(x -> ((ReadableSpanWithPriority)x).readableSpan.toSpanData()).collect(Collectors.toList());
            }
            ArrayList<ReadableSpanWithPriority> readableSpansWithPriority = new ArrayList<ReadableSpanWithPriority>(this.queue.size());
            int numberOfSampledSpansWithMaxDiscardedRValue = 0;
            int numSampledSpansWithGreaterRValueAndSmallPValue = 0;
            for (ReadableSpanWithPriority readableSpanWithPriority : this.queue) {
                if (readableSpanWithPriority.getR() == this.maxDiscardedRValue) {
                    ++numberOfSampledSpansWithMaxDiscardedRValue;
                } else if (readableSpanWithPriority.getP() <= this.maxDiscardedRValue) {
                    ++numSampledSpansWithGreaterRValueAndSmallPValue;
                }
                readableSpansWithPriority.add(readableSpanWithPriority);
            }
            double expectedNumPValueIncrements = (double)numSampledSpansWithGreaterRValueAndSmallPValue * ((double)this.numberOfDiscardedSpansWithMaxDiscardedRValue / (double)(this.numberOfDiscardedSpansWithMaxDiscardedRValue + (long)numberOfSampledSpansWithMaxDiscardedRValue + 1L));
            int roundedExpectedNumPValueIncrements = Math.toIntExact(this.randomGenerator.roundStochastically(expectedNumPValueIncrements));
            BitSet incrementIndicators = this.randomGenerator.generateRandomBitSet(numSampledSpansWithGreaterRValueAndSmallPValue, roundedExpectedNumPValueIncrements);
            int incrementIndicatorIndex = 0;
            ArrayList<SpanData> result = new ArrayList<SpanData>(this.queue.size());
            for (ReadableSpanWithPriority readableSpanWithPriority : readableSpansWithPriority) {
                SpanData spanData;
                SpanContext spanContext;
                TraceState traceState;
                String otelTraceStateString;
                OtelTraceState otelTraceState;
                if (readableSpanWithPriority.getP() <= this.maxDiscardedRValue) {
                    readableSpanWithPriority.setP(this.maxDiscardedRValue);
                    if (readableSpanWithPriority.getR() > this.maxDiscardedRValue) {
                        if (incrementIndicators.get(incrementIndicatorIndex)) {
                            readableSpanWithPriority.setP(this.maxDiscardedRValue + 1);
                        }
                        ++incrementIndicatorIndex;
                    }
                }
                if (!(otelTraceState = OtelTraceState.parse(otelTraceStateString = (traceState = (spanContext = (spanData = readableSpanWithPriority.getReadableSpan().toSpanData()).getSpanContext()).getTraceState()).get("ot"))).hasValidR() && readableSpanWithPriority.getP() > 0 || otelTraceState.hasValidR() && readableSpanWithPriority.getP() != otelTraceState.getP()) {
                    otelTraceState.setP(readableSpanWithPriority.getP());
                    spanData = ConsistentReservoirSamplingSpanProcessor.updateSpanDataWithOtelTraceState(spanData, otelTraceState);
                }
                result.add(spanData);
            }
            return result;
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }

    private static final class ReadableSpanWithPriority {
        private final ReadableSpan readableSpan;
        private int pval;
        private final int rval;
        private final long priority;

        public static ReadableSpanWithPriority create(ReadableSpan readableSpan, RandomGenerator randomGenerator) {
            String otelTraceStateString = readableSpan.getSpanContext().getTraceState().get("ot");
            OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
            long priority = randomGenerator.nextLong();
            int rval = otelTraceState.hasValidR() ? otelTraceState.getR() : Math.min(randomGenerator.numberOfLeadingZerosOfRandomLong(), OtelTraceState.getMaxR());
            int pval = otelTraceState.hasValidP() ? otelTraceState.getP() : 0;
            return new ReadableSpanWithPriority(readableSpan, pval, rval, priority);
        }

        private ReadableSpanWithPriority(ReadableSpan readableSpan, int pval, int rval, long priority) {
            this.readableSpan = readableSpan;
            this.pval = pval;
            this.rval = rval;
            this.priority = priority;
        }

        private ReadableSpan getReadableSpan() {
            return this.readableSpan;
        }

        private int getP() {
            return this.pval;
        }

        private void setP(int pval) {
            this.pval = pval;
        }

        private int getR() {
            return this.rval;
        }

        private static int compareRthenPriority(ReadableSpanWithPriority s1, ReadableSpanWithPriority s2) {
            int compareR = Integer.compare(s1.rval, s2.rval);
            if (compareR != 0) {
                return compareR;
            }
            return Long.compare(s1.priority, s2.priority);
        }
    }
}

