/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ComposableSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAlwaysOffSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAlwaysOnSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAnyOf;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentFixedThresholdSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentParentBasedSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentRateLimitingSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentRuleBasedSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.OtelTraceState;
import io.opentelemetry.contrib.sampler.consistent56.PredicatedSampler;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;

public abstract class ConsistentSampler
implements Sampler,
ComposableSampler {
    public static ConsistentSampler alwaysOn() {
        return ConsistentAlwaysOnSampler.getInstance();
    }

    public static ConsistentSampler alwaysOff() {
        return ConsistentAlwaysOffSampler.getInstance();
    }

    public static ConsistentSampler probabilityBased(double samplingProbability) {
        long threshold = ConsistentSamplingUtil.calculateThreshold(samplingProbability);
        return new ConsistentFixedThresholdSampler(threshold);
    }

    public static ConsistentSampler parentBased(ComposableSampler rootSampler) {
        return new ConsistentParentBasedSampler(rootSampler);
    }

    public static ConsistentRuleBasedSampler ruleBased(@Nullable SpanKind spanKindToMatch, PredicatedSampler ... samplers) {
        return new ConsistentRuleBasedSampler(spanKindToMatch, samplers);
    }

    static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds) {
        return ConsistentSampler.rateLimited(ConsistentSampler.alwaysOn(), targetSpansPerSecondLimit, adaptationTimeSeconds);
    }

    public static ConsistentSampler rateLimited(ComposableSampler delegate, double targetSpansPerSecondLimit, double adaptationTimeSeconds) {
        return ConsistentSampler.rateLimited(delegate, targetSpansPerSecondLimit, adaptationTimeSeconds, System::nanoTime);
    }

    static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds, LongSupplier nanoTimeSupplier) {
        return ConsistentSampler.rateLimited(ConsistentSampler.alwaysOn(), targetSpansPerSecondLimit, adaptationTimeSeconds, nanoTimeSupplier);
    }

    static ConsistentSampler rateLimited(ComposableSampler delegate, double targetSpansPerSecondLimit, double adaptationTimeSeconds, LongSupplier nanoTimeSupplier) {
        return new ConsistentRateLimitingSampler(delegate, targetSpansPerSecondLimit, adaptationTimeSeconds, nanoTimeSupplier);
    }

    public static ConsistentSampler anyOf(ComposableSampler ... delegates) {
        return new ConsistentAnyOf(delegates);
    }

    public final SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SamplingDecision samplingDecision;
        long randomness;
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        TraceState parentTraceState = parentSpanContext.getTraceState();
        String otelTraceStateString = parentTraceState.get("ot");
        OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
        final SamplingIntent intent = this.getSamplingIntent(parentContext, name, spanKind, attributes, parentLinks);
        long threshold = intent.getThreshold();
        boolean isSampled = ConsistentSamplingUtil.isValidThreshold(threshold) ? threshold <= (randomness = ConsistentSampler.getRandomness(otelTraceState, traceId)) : false;
        if (isSampled) {
            samplingDecision = SamplingDecision.RECORD_AND_SAMPLE;
            otelTraceState.setThreshold(threshold);
        } else {
            samplingDecision = SamplingDecision.DROP;
            otelTraceState.invalidateThreshold();
        }
        final String newOtTraceState = otelTraceState.serialize();
        return new SamplingResult(){

            public SamplingDecision getDecision() {
                return samplingDecision;
            }

            public Attributes getAttributes() {
                return intent.getAttributes();
            }

            public TraceState getUpdatedTraceState(TraceState parentTraceState) {
                return intent.updateTraceState(parentTraceState).toBuilder().put("ot", newOtTraceState).build();
            }
        };
    }

    private static long getRandomness(OtelTraceState otelTraceState, String traceId) {
        if (otelTraceState.hasValidRandomValue()) {
            return otelTraceState.getRandomValue();
        }
        return OtelTraceState.parseHex(traceId, 18, 14, ConsistentSamplingUtil.getInvalidRandomValue());
    }
}

