/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;

public class ConsistentFixedThresholdSampler
extends ConsistentSampler {
    private final long threshold;
    private final String description;

    protected ConsistentFixedThresholdSampler(long threshold) {
        ConsistentSamplingUtil.checkThreshold(threshold);
        this.threshold = threshold;
        String thresholdString = threshold == ConsistentSamplingUtil.getMaxThreshold() ? "max" : ConsistentSamplingUtil.appendLast56BitHexEncodedWithoutTrailingZeros(new StringBuilder(), threshold).toString();
        this.description = "ConsistentFixedThresholdSampler{threshold=" + thresholdString + ", sampling probability=" + ConsistentSamplingUtil.calculateSamplingProbability(threshold) + "}";
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected long getThreshold(long parentThreshold, boolean isRoot) {
        return this.threshold;
    }
}

