/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.RandomValueGenerator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentComposedAndSampler
extends ConsistentSampler {
    private final ConsistentSampler sampler1;
    private final ConsistentSampler sampler2;
    private final String description;

    ConsistentComposedAndSampler(ConsistentSampler sampler1, ConsistentSampler sampler2, RandomValueGenerator randomValueGenerator) {
        super(randomValueGenerator);
        this.sampler1 = Objects.requireNonNull(sampler1);
        this.sampler2 = Objects.requireNonNull(sampler2);
        this.description = "ConsistentComposedAndSampler{sampler1=" + sampler1.getDescription() + ",sampler2=" + sampler2.getDescription() + '}';
    }

    @Override
    protected long getThreshold(long parentThreshold, boolean isRoot) {
        long threshold1 = this.sampler1.getThreshold(parentThreshold, isRoot);
        long threshold2 = this.sampler2.getThreshold(parentThreshold, isRoot);
        if (ConsistentSamplingUtil.isValidThreshold(threshold1) && ConsistentSamplingUtil.isValidThreshold(threshold2)) {
            return Math.max(threshold1, threshold2);
        }
        return ConsistentSamplingUtil.getInvalidThreshold();
    }

    public String getDescription() {
        return this.description;
    }
}

