/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAlwaysOffSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAlwaysOnSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentComposedAndSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentComposedOrSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentFixedThresholdSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentParentBasedSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentRateLimitingSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.OtelTraceState;
import io.opentelemetry.contrib.sampler.consistent56.RandomValueGenerator;
import io.opentelemetry.contrib.sampler.consistent56.RandomValueGenerators;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;

public abstract class ConsistentSampler
implements Sampler {
    private final RandomValueGenerator randomValueGenerator;

    public static ConsistentSampler alwaysOn() {
        return ConsistentSampler.alwaysOn(RandomValueGenerators.getDefault());
    }

    public static ConsistentSampler alwaysOn(RandomValueGenerator randomValueGenerator) {
        return new ConsistentAlwaysOnSampler(randomValueGenerator);
    }

    public static ConsistentSampler alwaysOff() {
        return ConsistentSampler.alwaysOff(RandomValueGenerators.getDefault());
    }

    public static ConsistentSampler alwaysOff(RandomValueGenerator randomValueGenerator) {
        return new ConsistentAlwaysOffSampler(randomValueGenerator);
    }

    public static ConsistentSampler probabilityBased(double samplingProbability) {
        return ConsistentSampler.probabilityBased(samplingProbability, RandomValueGenerators.getDefault());
    }

    public static ConsistentSampler probabilityBased(double samplingProbability, RandomValueGenerator randomValueGenerator) {
        long threshold = ConsistentSamplingUtil.calculateThreshold(samplingProbability);
        return new ConsistentFixedThresholdSampler(threshold, randomValueGenerator);
    }

    public static ConsistentSampler parentBased(ConsistentSampler rootSampler) {
        return ConsistentSampler.parentBased(rootSampler, RandomValueGenerators.getDefault());
    }

    public static ConsistentSampler parentBased(ConsistentSampler rootSampler, RandomValueGenerator randomValueGenerator) {
        return new ConsistentParentBasedSampler(rootSampler, randomValueGenerator);
    }

    public static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds) {
        return ConsistentSampler.rateLimited(targetSpansPerSecondLimit, adaptationTimeSeconds, RandomValueGenerators.getDefault());
    }

    public static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds, RandomValueGenerator randomValueGenerator) {
        return ConsistentSampler.rateLimited(targetSpansPerSecondLimit, adaptationTimeSeconds, randomValueGenerator, System::nanoTime);
    }

    static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds, RandomValueGenerator randomValueGenerator, LongSupplier nanoTimeSupplier) {
        return new ConsistentRateLimitingSampler(targetSpansPerSecondLimit, adaptationTimeSeconds, randomValueGenerator, nanoTimeSupplier);
    }

    public ConsistentSampler and(ConsistentSampler otherConsistentSampler) {
        if (otherConsistentSampler == this) {
            return this;
        }
        return new ConsistentComposedAndSampler(this, otherConsistentSampler, RandomValueGenerators.getDefault());
    }

    public ConsistentSampler or(ConsistentSampler otherConsistentSampler) {
        if (otherConsistentSampler == this) {
            return this;
        }
        return new ConsistentComposedOrSampler(this, otherConsistentSampler, RandomValueGenerators.getDefault());
    }

    protected ConsistentSampler(RandomValueGenerator randomValueGenerator) {
        this.randomValueGenerator = Objects.requireNonNull(randomValueGenerator);
    }

    public final SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        boolean isSampled;
        long threshold;
        long randomValue;
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        boolean isRoot = !parentSpanContext.isValid();
        boolean isParentSampled = parentSpanContext.isSampled();
        boolean isRandomTraceIdFlagSet = false;
        TraceState parentTraceState = parentSpanContext.getTraceState();
        String otelTraceStateString = parentTraceState.get("ot");
        OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
        if (otelTraceState.hasValidRandomValue()) {
            randomValue = otelTraceState.getRandomValue();
        } else if (isRandomTraceIdFlagSet) {
            randomValue = OtelTraceState.parseHex(traceId, 18, 14, ConsistentSamplingUtil.getInvalidRandomValue());
        } else {
            randomValue = this.randomValueGenerator.generate(traceId);
            otelTraceState.invalidateThreshold();
            otelTraceState.setRandomValue(randomValue);
        }
        long parentThreshold = otelTraceState.hasValidThreshold() ? (randomValue >= (threshold = otelTraceState.getThreshold()) == isParentSampled ? threshold : ConsistentSamplingUtil.getInvalidThreshold()) : ConsistentSamplingUtil.getInvalidThreshold();
        threshold = this.getThreshold(parentThreshold, isRoot);
        if (ConsistentSamplingUtil.isValidThreshold(threshold)) {
            isSampled = randomValue >= threshold;
            otelTraceState.setThreshold(threshold);
        } else {
            isSampled = isParentSampled;
            otelTraceState.invalidateThreshold();
        }
        final SamplingDecision samplingDecision = isSampled ? SamplingDecision.RECORD_AND_SAMPLE : SamplingDecision.DROP;
        final String newOtTraceState = otelTraceState.serialize();
        return new SamplingResult(){

            public SamplingDecision getDecision() {
                return samplingDecision;
            }

            public Attributes getAttributes() {
                return Attributes.empty();
            }

            public TraceState getUpdatedTraceState(TraceState parentTraceState) {
                return parentTraceState.toBuilder().put("ot", newOtTraceState).build();
            }
        };
    }

    protected abstract long getThreshold(long var1, boolean var3);
}

