/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.samplers.ConsistentAlwaysOffSampler;
import io.opentelemetry.contrib.samplers.ConsistentAlwaysOnSampler;
import io.opentelemetry.contrib.samplers.ConsistentComposedAndSampler;
import io.opentelemetry.contrib.samplers.ConsistentComposedOrSampler;
import io.opentelemetry.contrib.samplers.ConsistentParentBasedSampler;
import io.opentelemetry.contrib.samplers.ConsistentProbabilityBasedSampler;
import io.opentelemetry.contrib.samplers.ConsistentRateLimitingSampler;
import io.opentelemetry.contrib.samplers.OtelTraceState;
import io.opentelemetry.contrib.samplers.RandomGenerator;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;

public abstract class ConsistentSampler
implements Sampler {
    protected final RandomGenerator randomGenerator;
    private static final double SMALLEST_POSITIVE_SAMPLING_PROBABILITY = ConsistentSampler.getSamplingProbability(OtelTraceState.getMaxP() - 1);

    public static final ConsistentSampler alwaysOn() {
        return ConsistentAlwaysOnSampler.getInstance();
    }

    public static final ConsistentSampler alwaysOff() {
        return ConsistentAlwaysOffSampler.getInstance();
    }

    public static final ConsistentSampler probabilityBased(double samplingProbability) {
        return new ConsistentProbabilityBasedSampler(samplingProbability);
    }

    static final ConsistentSampler probabilityBased(double samplingProbability, RandomGenerator randomGenerator) {
        return new ConsistentProbabilityBasedSampler(samplingProbability, randomGenerator);
    }

    public static final ConsistentSampler parentBased(ConsistentSampler rootSampler) {
        return new ConsistentParentBasedSampler(rootSampler);
    }

    static final ConsistentSampler parentBased(ConsistentSampler rootSampler, RandomGenerator randomGenerator) {
        return new ConsistentParentBasedSampler(rootSampler, randomGenerator);
    }

    public static final ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds) {
        return new ConsistentRateLimitingSampler(targetSpansPerSecondLimit, adaptationTimeSeconds);
    }

    static final ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds, RandomGenerator randomGenerator, LongSupplier nanoTimeSupplier) {
        return new ConsistentRateLimitingSampler(targetSpansPerSecondLimit, adaptationTimeSeconds, randomGenerator, nanoTimeSupplier);
    }

    public ConsistentSampler and(ConsistentSampler otherConsistentSampler) {
        if (otherConsistentSampler == this) {
            return this;
        }
        return new ConsistentComposedAndSampler(this, otherConsistentSampler);
    }

    public ConsistentSampler or(ConsistentSampler otherConsistentSampler) {
        if (otherConsistentSampler == this) {
            return this;
        }
        return new ConsistentComposedOrSampler(this, otherConsistentSampler);
    }

    protected ConsistentSampler(RandomGenerator randomGenerator) {
        this.randomGenerator = Objects.requireNonNull(randomGenerator);
    }

    protected ConsistentSampler() {
        this(RandomGenerator.getDefault());
    }

    private static final boolean isInvariantViolated(OtelTraceState otelTraceState, boolean isParentSampled) {
        if (otelTraceState.hasValidR() && otelTraceState.hasValidP()) {
            int p = otelTraceState.getP();
            int r = otelTraceState.getR();
            int maxP = OtelTraceState.getMaxP();
            boolean isInvariantTrue = p <= r == isParentSampled || isParentSampled && p == maxP;
            return !isInvariantTrue;
        }
        return false;
    }

    public final SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SamplingDecision samplingDecision;
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        boolean isRoot = !parentSpanContext.isValid();
        boolean isParentSampled = parentSpanContext.isSampled();
        TraceState parentTraceState = parentSpanContext.getTraceState();
        String otelTraceStateString = parentTraceState.get("ot");
        OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
        if (!otelTraceState.hasValidR() || ConsistentSampler.isInvariantViolated(otelTraceState, isParentSampled)) {
            otelTraceState.invalidateP();
        }
        if (!otelTraceState.hasValidR()) {
            otelTraceState.setR(Math.min(this.randomGenerator.numberOfLeadingZerosOfRandomLong(), OtelTraceState.getMaxR()));
        }
        int newP = this.getP(otelTraceState.getP(), isRoot);
        otelTraceState.setP(newP);
        boolean isSampled = otelTraceState.hasValidP() ? otelTraceState.getP() <= otelTraceState.getR() : isParentSampled;
        SamplingDecision samplingDecision2 = samplingDecision = isSampled ? SamplingDecision.RECORD_AND_SAMPLE : SamplingDecision.DROP;
        if (!isSampled) {
            otelTraceState.invalidateP();
        }
        final String newOtTraceState = otelTraceState.serialize();
        return new SamplingResult(){

            public SamplingDecision getDecision() {
                return samplingDecision;
            }

            public Attributes getAttributes() {
                return Attributes.empty();
            }

            public TraceState getUpdatedTraceState(TraceState parentTraceState) {
                return parentTraceState.toBuilder().put("ot", newOtTraceState).build();
            }
        };
    }

    protected abstract int getP(int var1, boolean var2);

    protected static double getSamplingProbability(int p) {
        if (OtelTraceState.isValidP(p)) {
            if (p == OtelTraceState.getMaxP()) {
                return 0.0;
            }
            return Double.longBitsToDouble(1023L - (long)p << 52);
        }
        throw new IllegalArgumentException("Invalid p-value!");
    }

    protected static int getLowerBoundP(double samplingProbability) {
        if (!(samplingProbability >= 0.0) || !(samplingProbability <= 1.0)) {
            throw new IllegalArgumentException();
        }
        if (samplingProbability == 0.0) {
            return OtelTraceState.getMaxP();
        }
        if (samplingProbability <= SMALLEST_POSITIVE_SAMPLING_PROBABILITY) {
            return OtelTraceState.getMaxP() - 1;
        }
        long longSamplingProbability = Double.doubleToRawLongBits(samplingProbability);
        long mantissa = longSamplingProbability & 0xFFFFFFFFFFFFFL;
        long exponent = longSamplingProbability >>> 52;
        return (int)(1023L - exponent) - (mantissa != 0L ? 1 : 0);
    }

    protected static int getUpperBoundP(double samplingProbability) {
        if (!(samplingProbability >= 0.0) || !(samplingProbability <= 1.0)) {
            throw new IllegalArgumentException();
        }
        if (samplingProbability <= SMALLEST_POSITIVE_SAMPLING_PROBABILITY) {
            return OtelTraceState.getMaxP();
        }
        long longSamplingProbability = Double.doubleToRawLongBits(samplingProbability);
        long exponent = longSamplingProbability >>> 52;
        return (int)(1023L - exponent);
    }
}

