/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.samplers;

import io.opentelemetry.contrib.samplers.ConsistentSampler;
import io.opentelemetry.contrib.samplers.OtelTraceState;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentComposedAndSampler
extends ConsistentSampler {
    private final ConsistentSampler sampler1;
    private final ConsistentSampler sampler2;
    private final String description;

    ConsistentComposedAndSampler(ConsistentSampler sampler1, ConsistentSampler sampler2) {
        this.sampler1 = Objects.requireNonNull(sampler1);
        this.sampler2 = Objects.requireNonNull(sampler2);
        this.description = "ConsistentComposedAndSampler{sampler1=" + sampler1.getDescription() + ",sampler2=" + sampler2.getDescription() + '}';
    }

    @Override
    protected int getP(int parentP, boolean isRoot) {
        int p1 = this.sampler1.getP(parentP, isRoot);
        int p2 = this.sampler2.getP(parentP, isRoot);
        if (OtelTraceState.isValidP(p1) && OtelTraceState.isValidP(p2)) {
            return Math.max(p1, p2);
        }
        return OtelTraceState.getInvalidP();
    }

    public String getDescription() {
        return this.description;
    }
}

