/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo;

import io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.opensergo.ConfigKind;
import io.opensergo.ConfigKindMetadata;
import io.opensergo.proto.fault_tolerance.v1.CircuitBreakerStrategy;
import io.opensergo.proto.fault_tolerance.v1.ConcurrencyLimitStrategy;
import io.opensergo.proto.fault_tolerance.v1.FaultToleranceRule;
import io.opensergo.proto.fault_tolerance.v1.RateLimitStrategy;
import io.opensergo.proto.fault_tolerance.v1.ThrottlingStrategy;
import io.opensergo.util.StringUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class OpenSergoConfigKindRegistry {
    private static final ConcurrentMap<String, ConfigKindMetadata> KIND_MAP = new ConcurrentHashMap<String, ConfigKindMetadata>();

    public static ConfigKindMetadata getKindMetadata(ConfigKind kind) {
        if (kind == null) {
            return null;
        }
        return (ConfigKindMetadata)KIND_MAP.get(kind.getKindName());
    }

    public static ConfigKindMetadata getKindMetadata(String kindName) {
        if (StringUtils.isEmpty(kindName)) {
            return null;
        }
        return (ConfigKindMetadata)KIND_MAP.get(kindName);
    }

    private static void registerConfigKind(ConfigKind kind, Class<?> clazz) {
        KIND_MAP.put(kind.getKindName(), new ConfigKindMetadata(kind, clazz));
    }

    private OpenSergoConfigKindRegistry() {
    }

    static {
        OpenSergoConfigKindRegistry.registerConfigKind(ConfigKind.FAULT_TOLERANCE_RULE, FaultToleranceRule.class);
        OpenSergoConfigKindRegistry.registerConfigKind(ConfigKind.RATE_LIMIT_STRATEGY, RateLimitStrategy.class);
        OpenSergoConfigKindRegistry.registerConfigKind(ConfigKind.THROTTLING_STRATEGY, ThrottlingStrategy.class);
        OpenSergoConfigKindRegistry.registerConfigKind(ConfigKind.CONCURRENCY_LIMIT_STRATEGY, ConcurrencyLimitStrategy.class);
        OpenSergoConfigKindRegistry.registerConfigKind(ConfigKind.CIRCUIT_BREAKER_STRATEGY, CircuitBreakerStrategy.class);
        OpenSergoConfigKindRegistry.registerConfigKind(ConfigKind.TRAFFIC_ROUTER_STRATEGY, RouteConfiguration.class);
    }
}

