/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.protocol;

import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.protocol.RequestOrResponse;
import io.openmessaging.storage.dledger.utils.PreConditions;
import java.util.ArrayList;
import java.util.List;

public class PushEntryRequest
extends RequestOrResponse {
    private long commitIndex = -1L;
    private Type type = Type.APPEND;
    private DLedgerEntry entry;
    private List<DLedgerEntry> batchEntry = new ArrayList<DLedgerEntry>();
    private int totalSize;

    public DLedgerEntry getEntry() {
        return this.entry;
    }

    public void setEntry(DLedgerEntry entry) {
        this.entry = entry;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void setCommitIndex(long commitIndex) {
        this.commitIndex = commitIndex;
    }

    public void addEntry(DLedgerEntry entry) {
        if (!this.batchEntry.isEmpty()) {
            PreConditions.check(this.batchEntry.get(0).getIndex() + (long)this.batchEntry.size() == entry.getIndex(), DLedgerResponseCode.UNKNOWN, "batch push wrong order");
        }
        this.batchEntry.add(entry);
        this.totalSize += entry.getSize();
    }

    public long getFirstEntryIndex() {
        if (!this.batchEntry.isEmpty()) {
            return this.batchEntry.get(0).getIndex();
        }
        if (this.entry != null) {
            return this.entry.getIndex();
        }
        return -1L;
    }

    public long getLastEntryIndex() {
        if (!this.batchEntry.isEmpty()) {
            return this.batchEntry.get(this.batchEntry.size() - 1).getIndex();
        }
        if (this.entry != null) {
            return this.entry.getIndex();
        }
        return -1L;
    }

    public int getCount() {
        return this.batchEntry.size();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public List<DLedgerEntry> getBatchEntry() {
        return this.batchEntry;
    }

    public void clear() {
        this.batchEntry.clear();
        this.totalSize = 0;
    }

    public boolean isBatch() {
        return !this.batchEntry.isEmpty();
    }

    public static enum Type {
        APPEND,
        COMMIT,
        COMPARE,
        TRUNCATE;

    }
}

