/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.command;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.openmessaging.storage.dledger.client.DLedgerClient;
import io.openmessaging.storage.dledger.command.BaseCommand;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Leadership transfer")
public class LeadershipTransferCommand
extends BaseCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeadershipTransferCommand.class);
    @Parameter(names={"--group", "-g"}, description="Group of this server")
    private String group = "default";
    @Parameter(names={"--peers", "-p"}, description="Peer info of this server")
    private String peers = "n0-localhost:20911";
    @Parameter(names={"--leader", "-l"}, description="set the current leader manually")
    private String leaderId;
    @Parameter(names={"--transfereeId", "-t"}, description="Node try to be the new leader")
    private String transfereeId = "n0";
    @Parameter(names={"--term"}, description="current term")
    private long term;

    @Override
    public void doCommand() {
        DLedgerClient dLedgerClient = new DLedgerClient(this.group, this.peers);
        dLedgerClient.startup();
        LeadershipTransferResponse response = dLedgerClient.leadershipTransfer(this.leaderId, this.transfereeId, this.term);
        LOGGER.info("LeadershipTransfer code={}, Result:{}", (Object)DLedgerResponseCode.valueOf((int)response.getCode()), (Object)JSON.toJSONString((Object)response));
        dLedgerClient.shutdown();
    }
}

