/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.export;

import com.google.common.collect.EvictingQueue;
import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.trace.SpanImpl;
import io.opencensus.trace.Status;
import io.opencensus.trace.export.SampledSpanStore;
import io.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SampledSpanStoreImpl
extends SampledSpanStore {
    private static final int NUM_SAMPLES_PER_LATENCY_BUCKET = 10;
    private static final int NUM_SAMPLES_PER_ERROR_BUCKET = 5;
    private static final long TIME_BETWEEN_SAMPLES = TimeUnit.SECONDS.toNanos(1L);
    private static final int NUM_LATENCY_BUCKETS = SampledSpanStore.LatencyBucketBoundaries.values().length;
    private static final int NUM_ERROR_BUCKETS = Status.CanonicalCode.values().length - 1;
    private static final int MAX_PER_SPAN_NAME_SAMPLES = 10 * NUM_LATENCY_BUCKETS + 5 * NUM_ERROR_BUCKETS;
    private final EventQueue eventQueue;
    @GuardedBy(value="samples")
    private final Map<String, PerSpanNameSamples> samples = new HashMap<String, PerSpanNameSamples>();

    SampledSpanStoreImpl(EventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampledSpanStore.Summary getSummary() {
        HashMap<String, SampledSpanStore.PerSpanNameSummary> ret = new HashMap<String, SampledSpanStore.PerSpanNameSummary>();
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            for (Map.Entry<String, PerSpanNameSamples> it : this.samples.entrySet()) {
                ret.put(it.getKey(), SampledSpanStore.PerSpanNameSummary.create((Map)it.getValue().getNumbersOfLatencySampledSpans(), (Map)it.getValue().getNumbersOfErrorSampledSpans()));
            }
        }
        return SampledSpanStore.Summary.create(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void considerForSampling(SpanImpl span) {
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            PerSpanNameSamples perSpanNameSamples;
            String spanName = span.getName();
            if (span.getSampleToLocalSpanStore() && !this.samples.containsKey(spanName)) {
                this.samples.put(spanName, new PerSpanNameSamples());
            }
            if ((perSpanNameSamples = this.samples.get(spanName)) != null) {
                perSpanNameSamples.considerForSampling(span);
            }
        }
    }

    public void registerSpanNamesForCollection(Collection<String> spanNames) {
        this.eventQueue.enqueue(new RegisterSpanNameEvent(this, spanNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internaltRegisterSpanNamesForCollection(Collection<String> spanNames) {
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            for (String spanName : spanNames) {
                if (this.samples.containsKey(spanName)) continue;
                this.samples.put(spanName, new PerSpanNameSamples());
            }
        }
    }

    public void unregisterSpanNamesForCollection(Collection<String> spanNames) {
        this.eventQueue.enqueue(new UnregisterSpanNameEvent(this, spanNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterSpanNamesForCollection(Collection<String> spanNames) {
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            this.samples.keySet().removeAll(spanNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRegisteredSpanNamesForCollection() {
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<String>(this.samples.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SpanData> getErrorSampledSpans(SampledSpanStore.ErrorFilter filter) {
        int numSpansToReturn = filter.getMaxSpansToReturn() == 0 ? MAX_PER_SPAN_NAME_SAMPLES : filter.getMaxSpansToReturn();
        List spans = Collections.emptyList();
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            PerSpanNameSamples perSpanNameSamples = this.samples.get(filter.getSpanName());
            if (perSpanNameSamples != null) {
                spans = perSpanNameSamples.getErrorSamples(filter.getCanonicalCode(), numSpansToReturn);
            }
        }
        ArrayList<SpanData> ret = new ArrayList<SpanData>(spans.size());
        for (SpanImpl span : spans) {
            ret.add(span.toSpanData());
        }
        return Collections.unmodifiableList(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SpanData> getLatencySampledSpans(SampledSpanStore.LatencyFilter filter) {
        int numSpansToReturn = filter.getMaxSpansToReturn() == 0 ? MAX_PER_SPAN_NAME_SAMPLES : filter.getMaxSpansToReturn();
        List spans = Collections.emptyList();
        Map<String, PerSpanNameSamples> map = this.samples;
        synchronized (map) {
            PerSpanNameSamples perSpanNameSamples = this.samples.get(filter.getSpanName());
            if (perSpanNameSamples != null) {
                spans = perSpanNameSamples.getLatencySamples(filter.getLatencyLowerNs(), filter.getLatencyUpperNs(), numSpansToReturn);
            }
        }
        ArrayList<SpanData> ret = new ArrayList<SpanData>(spans.size());
        for (SpanImpl span : spans) {
            ret.add(span.toSpanData());
        }
        return Collections.unmodifiableList(ret);
    }

    private static final class UnregisterSpanNameEvent
    implements EventQueue.Entry {
        private final SampledSpanStoreImpl sampledSpanStore;
        private final Collection<String> spanNames;

        private UnregisterSpanNameEvent(SampledSpanStoreImpl sampledSpanStore, Collection<String> spanNames) {
            this.sampledSpanStore = sampledSpanStore;
            this.spanNames = new ArrayList<String>(spanNames);
        }

        @Override
        public void process() {
            this.sampledSpanStore.internalUnregisterSpanNamesForCollection(this.spanNames);
        }
    }

    private static final class RegisterSpanNameEvent
    implements EventQueue.Entry {
        private final SampledSpanStoreImpl sampledSpanStore;
        private final Collection<String> spanNames;

        private RegisterSpanNameEvent(SampledSpanStoreImpl sampledSpanStore, Collection<String> spanNames) {
            this.sampledSpanStore = sampledSpanStore;
            this.spanNames = new ArrayList<String>(spanNames);
        }

        @Override
        public void process() {
            this.sampledSpanStore.internaltRegisterSpanNamesForCollection(this.spanNames);
        }
    }

    private static final class PerSpanNameSamples {
        private final Bucket[] latencyBuckets = new Bucket[SampledSpanStoreImpl.access$100()];
        private final Bucket[] errorBuckets;

        private PerSpanNameSamples() {
            int i;
            for (i = 0; i < NUM_LATENCY_BUCKETS; ++i) {
                this.latencyBuckets[i] = new Bucket(10);
            }
            this.errorBuckets = new Bucket[NUM_ERROR_BUCKETS];
            for (i = 0; i < NUM_ERROR_BUCKETS; ++i) {
                this.errorBuckets[i] = new Bucket(5);
            }
        }

        private Bucket getLatencyBucket(long latencyNs) {
            for (int i = 0; i < NUM_LATENCY_BUCKETS; ++i) {
                SampledSpanStore.LatencyBucketBoundaries boundaries = SampledSpanStore.LatencyBucketBoundaries.values()[i];
                if (latencyNs < boundaries.getLatencyLowerNs() || latencyNs >= boundaries.getLatencyUpperNs()) continue;
                return this.latencyBuckets[i];
            }
            return null;
        }

        private Bucket getErrorBucket(Status.CanonicalCode code) {
            return this.errorBuckets[code.value() - 1];
        }

        private void considerForSampling(SpanImpl span) {
            Status status = span.getStatus();
            if (status != null) {
                Bucket bucket;
                Bucket bucket2 = bucket = status.isOk() ? this.getLatencyBucket(span.getLatencyNs()) : this.getErrorBucket(status.getCanonicalCode());
                if (bucket != null) {
                    bucket.considerForSampling(span);
                }
            }
        }

        private Map<SampledSpanStore.LatencyBucketBoundaries, Integer> getNumbersOfLatencySampledSpans() {
            EnumMap<SampledSpanStore.LatencyBucketBoundaries, Integer> latencyBucketSummaries = new EnumMap<SampledSpanStore.LatencyBucketBoundaries, Integer>(SampledSpanStore.LatencyBucketBoundaries.class);
            for (int i = 0; i < NUM_LATENCY_BUCKETS; ++i) {
                latencyBucketSummaries.put(SampledSpanStore.LatencyBucketBoundaries.values()[i], this.latencyBuckets[i].getNumSamples());
            }
            return latencyBucketSummaries;
        }

        private Map<Status.CanonicalCode, Integer> getNumbersOfErrorSampledSpans() {
            EnumMap<Status.CanonicalCode, Integer> errorBucketSummaries = new EnumMap<Status.CanonicalCode, Integer>(Status.CanonicalCode.class);
            for (int i = 0; i < NUM_ERROR_BUCKETS; ++i) {
                errorBucketSummaries.put(Status.CanonicalCode.values()[i + 1], this.errorBuckets[i].getNumSamples());
            }
            return errorBucketSummaries;
        }

        private List<SpanImpl> getErrorSamples(Status.CanonicalCode code, int maxSpansToReturn) {
            ArrayList<SpanImpl> output = new ArrayList<SpanImpl>(maxSpansToReturn);
            if (code != null) {
                this.getErrorBucket(code).getSamples(maxSpansToReturn, output);
            } else {
                for (int i = 0; i < NUM_ERROR_BUCKETS; ++i) {
                    this.errorBuckets[i].getSamples(maxSpansToReturn, output);
                }
            }
            return output;
        }

        private List<SpanImpl> getLatencySamples(long latencyLowerNs, long latencyUpperNs, int maxSpansToReturn) {
            ArrayList<SpanImpl> output = new ArrayList<SpanImpl>(maxSpansToReturn);
            for (int i = 0; i < NUM_LATENCY_BUCKETS; ++i) {
                SampledSpanStore.LatencyBucketBoundaries boundaries = SampledSpanStore.LatencyBucketBoundaries.values()[i];
                if (latencyUpperNs < boundaries.getLatencyLowerNs() || latencyLowerNs >= boundaries.getLatencyUpperNs()) continue;
                this.latencyBuckets[i].getSamplesFilteredByLatency(latencyLowerNs, latencyUpperNs, maxSpansToReturn, output);
            }
            return output;
        }
    }

    private static final class Bucket {
        private final EvictingQueue<SpanImpl> sampledSpansQueue;
        private final EvictingQueue<SpanImpl> notSampledSpansQueue;
        private long lastSampledNanoTime;
        private long lastNotSampledNanoTime;

        private Bucket(int numSamples) {
            this.sampledSpansQueue = EvictingQueue.create((int)numSamples);
            this.notSampledSpansQueue = EvictingQueue.create((int)numSamples);
        }

        private void considerForSampling(SpanImpl span) {
            long spanEndNanoTime = span.getEndNanoTime();
            if (span.getContext().getTraceOptions().isSampled()) {
                if (spanEndNanoTime - this.lastSampledNanoTime > TIME_BETWEEN_SAMPLES) {
                    this.sampledSpansQueue.add((Object)span);
                    this.lastSampledNanoTime = spanEndNanoTime;
                }
            } else if (spanEndNanoTime - this.lastNotSampledNanoTime > TIME_BETWEEN_SAMPLES) {
                this.notSampledSpansQueue.add((Object)span);
                this.lastNotSampledNanoTime = spanEndNanoTime;
            }
        }

        private void getSamples(int maxSpansToReturn, List<SpanImpl> output) {
            Bucket.getSamples(this.sampledSpansQueue, maxSpansToReturn, output);
            Bucket.getSamples(this.notSampledSpansQueue, maxSpansToReturn, output);
        }

        private static void getSamples(EvictingQueue<SpanImpl> queue, int maxSpansToReturn, List<SpanImpl> output) {
            for (SpanImpl span : queue) {
                if (output.size() >= maxSpansToReturn) break;
                output.add(span);
            }
        }

        private void getSamplesFilteredByLatency(long latencyLowerNs, long latencyUpperNs, int maxSpansToReturn, List<SpanImpl> output) {
            Bucket.getSamplesFilteredByLatency(this.sampledSpansQueue, latencyLowerNs, latencyUpperNs, maxSpansToReturn, output);
            Bucket.getSamplesFilteredByLatency(this.notSampledSpansQueue, latencyLowerNs, latencyUpperNs, maxSpansToReturn, output);
        }

        private static void getSamplesFilteredByLatency(EvictingQueue<SpanImpl> queue, long latencyLowerNs, long latencyUpperNs, int maxSpansToReturn, List<SpanImpl> output) {
            for (SpanImpl span : queue) {
                if (output.size() >= maxSpansToReturn) break;
                long spanLatencyNs = span.getLatencyNs();
                if (spanLatencyNs < latencyLowerNs || spanLatencyNs >= latencyUpperNs) continue;
                output.add(span);
            }
        }

        private int getNumSamples() {
            return this.sampledSpansQueue.size() + this.notSampledSpansQueue.size();
        }
    }
}

