/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.implcore.internal.TimestampConverter;
import io.opencensus.implcore.trace.SpanImpl;
import io.opencensus.implcore.trace.internal.RandomHandler;
import io.opencensus.trace.Link;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.config.TraceParams;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

final class SpanBuilderImpl
extends SpanBuilder {
    private final Options options;
    private final String name;
    private final Span parent;
    private final SpanContext remoteParentSpanContext;
    private Sampler sampler;
    private List<Span> parentLinks = Collections.emptyList();
    private Boolean recordEvents;

    private SpanImpl startSpanInternal(@Nullable SpanContext parent, @Nullable Boolean hasRemoteParent, String name, Sampler sampler, List<Span> parentLinks, Boolean recordEvents, @Nullable TimestampConverter timestampConverter) {
        TraceOptions.Builder traceOptionsBuilder;
        TraceId traceId;
        TraceParams activeTraceParams = this.options.traceConfig.getActiveTraceParams();
        Random random = this.options.randomHandler.current();
        SpanId spanId = SpanId.generateRandomId((Random)random);
        SpanId parentSpanId = null;
        if (parent == null || !parent.isValid()) {
            traceId = TraceId.generateRandomId((Random)random);
            traceOptionsBuilder = TraceOptions.builder();
            hasRemoteParent = null;
        } else {
            traceId = parent.getTraceId();
            parentSpanId = parent.getSpanId();
            traceOptionsBuilder = TraceOptions.builder((TraceOptions)parent.getTraceOptions());
        }
        if (sampler == null) {
            sampler = activeTraceParams.getSampler();
        }
        if (sampler.shouldSample(parent, hasRemoteParent, traceId, spanId, name, parentLinks)) {
            traceOptionsBuilder.setIsSampled();
        }
        TraceOptions traceOptions = traceOptionsBuilder.build();
        EnumSet<Span.Options> spanOptions = EnumSet.noneOf(Span.Options.class);
        if (traceOptions.isSampled() || Boolean.TRUE.equals(recordEvents)) {
            spanOptions.add(Span.Options.RECORD_EVENTS);
        }
        SpanImpl span = SpanImpl.startSpan(SpanContext.create((TraceId)traceId, (SpanId)spanId, (TraceOptions)traceOptions), spanOptions, name, parentSpanId, hasRemoteParent, activeTraceParams, this.options.startEndHandler, timestampConverter, this.options.clock);
        SpanBuilderImpl.linkSpans(span, parentLinks);
        return span;
    }

    private static void linkSpans(Span span, List<Span> parentLinks) {
        if (!parentLinks.isEmpty()) {
            Link childLink = Link.fromSpanContext((SpanContext)span.getContext(), (Link.Type)Link.Type.CHILD_LINKED_SPAN);
            for (Span linkedSpan : parentLinks) {
                linkedSpan.addLink(childLink);
                span.addLink(Link.fromSpanContext((SpanContext)linkedSpan.getContext(), (Link.Type)Link.Type.PARENT_LINKED_SPAN));
            }
        }
    }

    static SpanBuilderImpl createWithParent(String spanName, @Nullable Span parent, Options options) {
        return new SpanBuilderImpl(spanName, null, parent, options);
    }

    static SpanBuilderImpl createWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext, Options options) {
        return new SpanBuilderImpl(spanName, remoteParentSpanContext, null, options);
    }

    private SpanBuilderImpl(String name, @Nullable SpanContext remoteParentSpanContext, @Nullable Span parent, Options options) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.parent = parent;
        this.remoteParentSpanContext = remoteParentSpanContext;
        this.options = options;
    }

    public SpanImpl startSpan() {
        SpanContext parentContext = this.remoteParentSpanContext;
        Boolean hasRemoteParent = Boolean.TRUE;
        TimestampConverter timestampConverter = null;
        if (this.remoteParentSpanContext == null) {
            Span parent = this.parent;
            hasRemoteParent = Boolean.FALSE;
            if (parent != null) {
                parentContext = parent.getContext();
                if (parent instanceof SpanImpl) {
                    timestampConverter = ((SpanImpl)parent).getTimestampConverter();
                }
            } else {
                hasRemoteParent = null;
            }
        }
        return this.startSpanInternal(parentContext, hasRemoteParent, this.name, this.sampler, this.parentLinks, this.recordEvents, timestampConverter);
    }

    public SpanBuilderImpl setSampler(Sampler sampler) {
        this.sampler = (Sampler)Preconditions.checkNotNull((Object)sampler, (Object)"sampler");
        return this;
    }

    public SpanBuilderImpl setParentLinks(List<Span> parentLinks) {
        this.parentLinks = (List)Preconditions.checkNotNull(parentLinks, (Object)"parentLinks");
        return this;
    }

    public SpanBuilderImpl setRecordEvents(boolean recordEvents) {
        this.recordEvents = recordEvents;
        return this;
    }

    static final class Options {
        private final RandomHandler randomHandler;
        private final SpanImpl.StartEndHandler startEndHandler;
        private final Clock clock;
        private final TraceConfig traceConfig;

        Options(RandomHandler randomHandler, SpanImpl.StartEndHandler startEndHandler, Clock clock, TraceConfig traceConfig) {
            this.randomHandler = (RandomHandler)Preconditions.checkNotNull((Object)randomHandler, (Object)"randomHandler");
            this.startEndHandler = (SpanImpl.StartEndHandler)Preconditions.checkNotNull((Object)startEndHandler, (Object)"startEndHandler");
            this.clock = (Clock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
            this.traceConfig = (TraceConfig)Preconditions.checkNotNull((Object)traceConfig, (Object)"traceConfig");
        }
    }
}

