/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.export;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.trace.SpanImpl;
import io.opencensus.trace.export.ExportComponent;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public final class SpanExporterImpl
extends SpanExporter {
    private static final Logger logger = Logger.getLogger(ExportComponent.class.getName());
    private final WorkerThread workerThread;

    static SpanExporterImpl create(int bufferSize, long scheduleDelayMillis) {
        WorkerThread workerThread = new WorkerThread(bufferSize, scheduleDelayMillis);
        workerThread.start();
        return new SpanExporterImpl(workerThread);
    }

    public void addSpan(SpanImpl span) {
        this.workerThread.addSpan(span);
    }

    public void registerHandler(String name, SpanExporter.Handler handler) {
        this.workerThread.registerHandler(name, handler);
    }

    public void unregisterHandler(String name) {
        this.workerThread.unregisterHandler(name);
    }

    private SpanExporterImpl(WorkerThread workerThread) {
        this.workerThread = workerThread;
    }

    @VisibleForTesting
    Thread getServiceExporterThread() {
        return this.workerThread;
    }

    private static final class WorkerThread
    extends Thread {
        private final Object monitor = new Object();
        @GuardedBy(value="monitor")
        private final List<SpanImpl> spans;
        private final Map<String, SpanExporter.Handler> serviceHandlers = new ConcurrentHashMap<String, SpanExporter.Handler>();
        private final int bufferSize;
        private final long scheduleDelayMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(SpanImpl span) {
            Object object = this.monitor;
            synchronized (object) {
                this.spans.add(span);
                if (this.spans.size() > this.bufferSize) {
                    this.monitor.notifyAll();
                }
            }
        }

        private void registerHandler(String name, SpanExporter.Handler serviceHandler) {
            this.serviceHandlers.put(name, serviceHandler);
        }

        private void unregisterHandler(String name) {
            this.serviceHandlers.remove(name);
        }

        private void onBatchExport(List<SpanData> spanDataList) {
            for (Map.Entry<String, SpanExporter.Handler> it : this.serviceHandlers.entrySet()) {
                try {
                    it.getValue().export(spanDataList);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exception thrown by the service export " + it.getKey(), e);
                }
            }
        }

        private WorkerThread(int bufferSize, long scheduleDelayMillis) {
            this.spans = new LinkedList<SpanImpl>();
            this.bufferSize = bufferSize;
            this.scheduleDelayMillis = scheduleDelayMillis;
            this.setDaemon(true);
            this.setName("ExportComponent.ServiceExporterThread");
        }

        private static List<SpanData> fromSpanImplToSpanData(List<SpanImpl> spans) {
            ArrayList<SpanData> spanDatas = new ArrayList<SpanData>(spans.size());
            for (SpanImpl span : spans) {
                spanDatas.add(span.toSpanData());
            }
            return Collections.unmodifiableList(spanDatas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ArrayList<SpanImpl> spansCopy;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.spans.size() < this.bufferSize) {
                        do {
                            try {
                                this.monitor.wait(this.scheduleDelayMillis);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        } while (this.spans.isEmpty());
                    }
                    spansCopy = new ArrayList<SpanImpl>(this.spans);
                    this.spans.clear();
                }
                List<SpanData> spanDataList = WorkerThread.fromSpanImplToSpanData(spansCopy);
                if (spanDataList.isEmpty()) continue;
                this.onBatchExport(spanDataList);
            }
        }
    }
}

