/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.opencensus.common.Duration;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.stats.MutableAggregation;
import io.opencensus.implcore.stats.RecordUtils;
import io.opencensus.metrics.data.AttachmentValue;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.Measure;
import io.opencensus.tags.TagValue;
import java.util.List;
import java.util.Map;

final class IntervalBucket {
    private static final Duration ZERO = Duration.create((long)0L, (int)0);
    private final Timestamp start;
    private final Duration duration;
    private final Aggregation aggregation;
    private final Measure measure;
    private final Map<List<TagValue>, MutableAggregation> tagValueAggregationMap = Maps.newHashMap();

    IntervalBucket(Timestamp start, Duration duration, Aggregation aggregation, Measure measure) {
        this.start = (Timestamp)Preconditions.checkNotNull((Object)start, (Object)"Start");
        this.duration = (Duration)Preconditions.checkNotNull((Object)duration, (Object)"Duration");
        Preconditions.checkArgument((duration.compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Duration must be positive");
        this.aggregation = (Aggregation)Preconditions.checkNotNull((Object)aggregation, (Object)"Aggregation");
        this.measure = (Measure)Preconditions.checkNotNull((Object)measure, (Object)"measure");
    }

    Map<List<TagValue>, MutableAggregation> getTagValueAggregationMap() {
        return this.tagValueAggregationMap;
    }

    Timestamp getStart() {
        return this.start;
    }

    void record(List<TagValue> tagValues, double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
        if (!this.tagValueAggregationMap.containsKey(tagValues)) {
            this.tagValueAggregationMap.put(tagValues, RecordUtils.createMutableAggregation(this.aggregation, this.measure));
        }
        this.tagValueAggregationMap.get(tagValues).add(value, attachments, timestamp);
    }

    double getFraction(Timestamp now) {
        Duration elapsedTime = now.subtractTimestamp(this.start);
        Preconditions.checkArgument((elapsedTime.compareTo(ZERO) >= 0 && elapsedTime.compareTo(this.duration) < 0 ? 1 : 0) != 0, (Object)"This bucket must be current.");
        return (double)elapsedTime.toMillis() / (double)this.duration.toMillis();
    }

    void clearStats() {
        this.tagValueAggregationMap.clear();
    }
}

