/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import com.google.common.base.Preconditions;
import io.opencensus.common.Scope;
import io.opencensus.implcore.tags.CurrentTagMapUtils;
import io.opencensus.implcore.tags.TagMapImpl;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.HashMap;
import java.util.Map;

final class TagMapBuilderImpl
extends TagContextBuilder {
    private final Map<TagKey, TagValue> tags;

    TagMapBuilderImpl(Map<TagKey, TagValue> tags) {
        this.tags = new HashMap<TagKey, TagValue>(tags);
    }

    TagMapBuilderImpl() {
        this.tags = new HashMap<TagKey, TagValue>();
    }

    public TagMapBuilderImpl put(TagKey key, TagValue value) {
        this.tags.put((TagKey)Preconditions.checkNotNull((Object)key, (Object)"key"), (TagValue)Preconditions.checkNotNull((Object)value, (Object)"value"));
        return this;
    }

    public TagMapBuilderImpl remove(TagKey key) {
        this.tags.remove(Preconditions.checkNotNull((Object)key, (Object)"key"));
        return this;
    }

    public TagMapImpl build() {
        return new TagMapImpl(this.tags);
    }

    public Scope buildScoped() {
        return CurrentTagMapUtils.withTagMap(this.build());
    }
}

