/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.common.ToLongFunction;
import io.opencensus.implcore.internal.Utils;
import io.opencensus.implcore.metrics.Meter;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class DerivedLongGaugeImpl
extends DerivedLongGauge
implements Meter {
    private final MetricDescriptor metricDescriptor;
    private final int labelKeysSize;
    private volatile Map<List<LabelValue>, PointWithFunction> registeredPoints = Collections.emptyMap();

    DerivedLongGaugeImpl(String name, String description, String unit, List<LabelKey> labelKeys) {
        this.labelKeysSize = labelKeys.size();
        this.metricDescriptor = MetricDescriptor.create((String)name, (String)description, (String)unit, (MetricDescriptor.Type)MetricDescriptor.Type.GAUGE_INT64, labelKeys);
    }

    public synchronized <T> void createTimeSeries(List<LabelValue> labelValues, T obj, ToLongFunction<T> function) {
        Utils.checkListElementNotNull((List)Preconditions.checkNotNull(labelValues, (Object)"labelValues"), "labelValue");
        Preconditions.checkArgument((this.labelKeysSize == labelValues.size() ? 1 : 0) != 0, (Object)"Label Keys and Label Values don't have same size.");
        Preconditions.checkNotNull(function, (Object)"function");
        List<LabelValue> labelValuesCopy = Collections.unmodifiableList(new ArrayList<LabelValue>(labelValues));
        PointWithFunction existingPoint = this.registeredPoints.get(labelValuesCopy);
        if (existingPoint != null) {
            throw new IllegalArgumentException("A different time series with the same labels already exists.");
        }
        PointWithFunction<T> newPoint = new PointWithFunction<T>(labelValuesCopy, obj, function);
        LinkedHashMap<List<LabelValue>, PointWithFunction> registeredPointsCopy = new LinkedHashMap<List<LabelValue>, PointWithFunction>(this.registeredPoints);
        registeredPointsCopy.put(labelValuesCopy, newPoint);
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    public synchronized void removeTimeSeries(List<LabelValue> labelValues) {
        Preconditions.checkNotNull(labelValues, (Object)"labelValues");
        LinkedHashMap<List<LabelValue>, PointWithFunction> registeredPointsCopy = new LinkedHashMap<List<LabelValue>, PointWithFunction>(this.registeredPoints);
        if (registeredPointsCopy.remove(labelValues) == null) {
            return;
        }
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    public synchronized void clear() {
        this.registeredPoints = Collections.emptyMap();
    }

    @Override
    public Metric getMetric(Clock clock) {
        Map<List<LabelValue>, PointWithFunction> currentRegisteredPoints = this.registeredPoints;
        if (currentRegisteredPoints.isEmpty()) {
            return null;
        }
        if (currentRegisteredPoints.size() == 1) {
            PointWithFunction point = currentRegisteredPoints.values().iterator().next();
            return Metric.createWithOneTimeSeries((MetricDescriptor)this.metricDescriptor, (TimeSeries)point.getTimeSeries(clock));
        }
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(currentRegisteredPoints.size());
        for (Map.Entry<List<LabelValue>, PointWithFunction> entry : currentRegisteredPoints.entrySet()) {
            timeSeriesList.add(entry.getValue().getTimeSeries(clock));
        }
        return Metric.create((MetricDescriptor)this.metricDescriptor, timeSeriesList);
    }

    public static final class PointWithFunction<T> {
        private final TimeSeries defaultTimeSeries;
        @Nullable
        private final WeakReference<T> ref;
        private final ToLongFunction<T> function;

        PointWithFunction(List<LabelValue> labelValues, T obj, ToLongFunction<T> function) {
            this.defaultTimeSeries = TimeSeries.create(labelValues);
            this.ref = obj != null ? new WeakReference<T>(obj) : null;
            this.function = function;
        }

        private TimeSeries getTimeSeries(Clock clock) {
            Object obj = this.ref != null ? this.ref.get() : null;
            long value = this.function.applyAsLong(obj);
            return this.defaultTimeSeries.setPoint(Point.create((Value)Value.longValue((long)value), (Timestamp)clock.now()));
        }
    }
}

