/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.export;

import io.opencensus.implcore.trace.RecordEventsSpanImpl;
import io.opencensus.implcore.trace.export.RunningSpanStoreImpl;
import io.opencensus.implcore.trace.internal.ConcurrentIntrusiveList;
import io.opencensus.trace.export.RunningSpanStore;
import io.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InProcessRunningSpanStoreImpl
extends RunningSpanStoreImpl {
    private final ConcurrentIntrusiveList<RecordEventsSpanImpl> runningSpans = new ConcurrentIntrusiveList();

    @Override
    public void onStart(RecordEventsSpanImpl span) {
        this.runningSpans.addElement(span);
    }

    @Override
    public void onEnd(RecordEventsSpanImpl span) {
        this.runningSpans.removeElement(span);
    }

    public RunningSpanStore.Summary getSummary() {
        Collection<RecordEventsSpanImpl> allRunningSpans = this.runningSpans.getAll();
        HashMap<String, Integer> numSpansPerName = new HashMap<String, Integer>();
        for (RecordEventsSpanImpl recordEventsSpanImpl : allRunningSpans) {
            Integer n = (Integer)numSpansPerName.get(recordEventsSpanImpl.getName());
            numSpansPerName.put(recordEventsSpanImpl.getName(), n != null ? n + 1 : 1);
        }
        HashMap perSpanNameSummary = new HashMap();
        for (Map.Entry entry : numSpansPerName.entrySet()) {
            perSpanNameSummary.put(entry.getKey(), RunningSpanStore.PerSpanNameSummary.create((int)((Integer)entry.getValue())));
        }
        RunningSpanStore.Summary summary = RunningSpanStore.Summary.create(perSpanNameSummary);
        return summary;
    }

    public Collection<SpanData> getRunningSpans(RunningSpanStore.Filter filter) {
        Collection<RecordEventsSpanImpl> allRunningSpans = this.runningSpans.getAll();
        int maxSpansToReturn = filter.getMaxSpansToReturn() == 0 ? allRunningSpans.size() : filter.getMaxSpansToReturn();
        ArrayList<SpanData> ret = new ArrayList<SpanData>(maxSpansToReturn);
        for (RecordEventsSpanImpl span : allRunningSpans) {
            if (ret.size() == maxSpansToReturn) break;
            if (!span.getName().equals(filter.getSpanName())) continue;
            ret.add(span.toSpanData());
        }
        return ret;
    }
}

