/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.common.ToDoubleFunction;
import io.opencensus.common.ToLongFunction;
import io.opencensus.implcore.temporary.metrics.LabelKey;
import io.opencensus.implcore.temporary.metrics.LabelValue;
import io.opencensus.implcore.temporary.metrics.Metric;
import io.opencensus.implcore.temporary.metrics.MetricDescriptor;
import io.opencensus.implcore.temporary.metrics.Point;
import io.opencensus.implcore.temporary.metrics.TimeSeries;
import io.opencensus.implcore.temporary.metrics.Value;
import java.util.Collections;
import java.util.List;

abstract class Gauge {
    private final MetricDescriptor metricDescriptor;
    private final List<LabelValue> labelValues;

    final Metric getMetric(Clock clock) {
        return Metric.create(this.metricDescriptor, Collections.singletonList(this.getTimeSeries(clock)));
    }

    abstract TimeSeries getTimeSeries(Clock var1);

    List<LabelValue> getLabelValues() {
        return this.labelValues;
    }

    Gauge(MetricDescriptor metricDescriptor, List<LabelValue> labelValues) {
        this.metricDescriptor = (MetricDescriptor)Preconditions.checkNotNull((Object)metricDescriptor, (Object)"metricDescriptor");
        this.labelValues = Collections.unmodifiableList(labelValues);
    }

    static final class LongGauge<T>
    extends Gauge {
        private final T obj;
        private final ToLongFunction<T> function;

        LongGauge(String name, String description, String unit, List<LabelKey> labelKeys, List<LabelValue> labelValues, T obj, ToLongFunction<T> function) {
            super(MetricDescriptor.create(name, description, unit, MetricDescriptor.Type.GAUGE_INT64, labelKeys), labelValues);
            this.obj = obj;
            this.function = function;
        }

        @Override
        TimeSeries getTimeSeries(Clock clock) {
            return TimeSeries.create(this.getLabelValues(), Collections.singletonList(Point.create(Value.longValue(this.function.applyAsLong(this.obj)), clock.now())), null);
        }
    }

    static final class DoubleGauge<T>
    extends Gauge {
        private final T obj;
        private final ToDoubleFunction<T> function;

        DoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys, List<LabelValue> labelValues, T obj, ToDoubleFunction<T> function) {
            super(MetricDescriptor.create(name, description, unit, MetricDescriptor.Type.GAUGE_DOUBLE, labelKeys), labelValues);
            this.obj = obj;
            this.function = function;
        }

        @Override
        TimeSeries getTimeSeries(Clock clock) {
            return TimeSeries.create(this.getLabelValues(), Collections.singletonList(Point.create(Value.doubleValue(this.function.applyAsDouble(this.obj)), clock.now())), null);
        }
    }
}

