/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TagContextImpl
extends TagContext {
    public static final TagContextImpl EMPTY = new TagContextImpl(Collections.emptyMap());
    private final Map<TagKey, TagValue> tags;

    public TagContextImpl(Map<? extends TagKey, ? extends TagValue> tags) {
        this.tags = Collections.unmodifiableMap(new HashMap<TagKey, TagValue>(tags));
    }

    public Map<TagKey, TagValue> getTags() {
        return this.tags;
    }

    protected Iterator<Tag> getIterator() {
        return new TagIterator(this.tags);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof TagContextImpl) {
            return this.getTags().equals(((TagContextImpl)((Object)other)).getTags());
        }
        return super.equals(other);
    }

    private static final class TagIterator
    implements Iterator<Tag> {
        Iterator<Map.Entry<TagKey, TagValue>> iterator;

        TagIterator(Map<TagKey, TagValue> tags) {
            this.iterator = tags.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Tag next() {
            Map.Entry<TagKey, TagValue> next = this.iterator.next();
            return Tag.create((TagKey)next.getKey(), (TagValue)next.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TagIterator.remove()");
        }
    }
}

