/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.SpanName;
import com.google.devtools.cloudtrace.v2.TruncatableString;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Int32Value;
import com.google.rpc.Status;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Scope;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.resource.util.ResourceUtils;
import io.opencensus.resource.Resource;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class StackdriverV2ExporterHandler
extends SpanExporter.Handler {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Sampler probabilitySampler = Samplers.probabilitySampler((double)1.0E-4);
    private static final String AGENT_LABEL_KEY = "g.co/agent";
    private static final String AGENT_LABEL_VALUE_STRING = "opencensus-java [0.24.0]";
    private static final String SERVER_PREFIX = "Recv.";
    private static final String CLIENT_PREFIX = "Sent.";
    private static final com.google.devtools.cloudtrace.v2.AttributeValue AGENT_LABEL_VALUE = com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder().setStringValue(StackdriverV2ExporterHandler.toTruncatableStringProto("opencensus-java [0.24.0]")).build();
    private static final ImmutableMap<String, String> HTTP_ATTRIBUTE_MAPPING = ImmutableMap.builder().put((Object)"http.host", (Object)"/http/host").put((Object)"http.method", (Object)"/http/method").put((Object)"http.path", (Object)"/http/path").put((Object)"http.route", (Object)"/http/route").put((Object)"http.user_agent", (Object)"/http/user_agent").put((Object)"http.status_code", (Object)"/http/status_code").build();
    private static final Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> RESOURCE_LABELS = StackdriverV2ExporterHandler.getResourceLabels(ResourceUtils.detectResource());
    private static final Function<String, com.google.devtools.cloudtrace.v2.AttributeValue> stringAttributeValueFunction = new Function<String, com.google.devtools.cloudtrace.v2.AttributeValue>(){

        public com.google.devtools.cloudtrace.v2.AttributeValue apply(String stringValue) {
            return com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder().setStringValue(StackdriverV2ExporterHandler.toTruncatableStringProto(stringValue)).build();
        }
    };
    private static final Function<Boolean, com.google.devtools.cloudtrace.v2.AttributeValue> booleanAttributeValueFunction = new Function<Boolean, com.google.devtools.cloudtrace.v2.AttributeValue>(){

        public com.google.devtools.cloudtrace.v2.AttributeValue apply(Boolean booleanValue) {
            return com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder().setBoolValue(booleanValue.booleanValue()).build();
        }
    };
    private static final Function<Long, com.google.devtools.cloudtrace.v2.AttributeValue> longAttributeValueFunction = new Function<Long, com.google.devtools.cloudtrace.v2.AttributeValue>(){

        public com.google.devtools.cloudtrace.v2.AttributeValue apply(Long longValue) {
            return com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder().setIntValue(longValue.longValue()).build();
        }
    };
    private static final Function<Double, com.google.devtools.cloudtrace.v2.AttributeValue> doubleAttributeValueFunction = new Function<Double, com.google.devtools.cloudtrace.v2.AttributeValue>(){

        public com.google.devtools.cloudtrace.v2.AttributeValue apply(Double doubleValue) {
            AttributeValue.Builder attributeValueBuilder = com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder();
            attributeValueBuilder.setStringValue(StackdriverV2ExporterHandler.toTruncatableStringProto(String.valueOf(doubleValue)));
            return attributeValueBuilder.build();
        }
    };
    private static final String EXPORT_STACKDRIVER_TRACES = "ExportStackdriverTraces";
    private static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> fixedAttributes;
    private final String projectId;
    private final TraceServiceClient traceServiceClient;
    private final ProjectName projectName;

    private StackdriverV2ExporterHandler(String projectId, TraceServiceClient traceServiceClient, Map<String, AttributeValue> fixedAttributes) {
        this.projectId = projectId;
        this.traceServiceClient = traceServiceClient;
        this.fixedAttributes = new HashMap<String, com.google.devtools.cloudtrace.v2.AttributeValue>();
        for (Map.Entry<String, AttributeValue> label : fixedAttributes.entrySet()) {
            com.google.devtools.cloudtrace.v2.AttributeValue value = StackdriverV2ExporterHandler.toAttributeValueProto(label.getValue());
            if (value == null) continue;
            this.fixedAttributes.put(label.getKey(), value);
        }
        this.projectName = ProjectName.of((String)this.projectId);
    }

    static StackdriverV2ExporterHandler createWithStub(String projectId, TraceServiceClient traceServiceClient, Map<String, AttributeValue> fixedAttributes) {
        return new StackdriverV2ExporterHandler(projectId, traceServiceClient, fixedAttributes);
    }

    static StackdriverV2ExporterHandler createWithCredentials(String projectId, Credentials credentials, Map<String, AttributeValue> fixedAttributes, Duration deadline) throws IOException {
        TraceServiceSettings.Builder builder = (TraceServiceSettings.Builder)TraceServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"credentials"))));
        builder.batchWriteSpansSettings().setSimpleTimeoutNoRetries(org.threeten.bp.Duration.ofMillis((long)deadline.toMillis()));
        return new StackdriverV2ExporterHandler(projectId, TraceServiceClient.create((TraceServiceSettings)builder.build()), fixedAttributes);
    }

    @VisibleForTesting
    com.google.devtools.cloudtrace.v2.Span generateSpan(SpanData spanData, Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> resourceLabels, Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> fixedAttributes) {
        Boolean hasRemoteParent;
        Timestamp end;
        SpanContext context = spanData.getContext();
        String spanIdHex = context.getSpanId().toLowerBase16();
        SpanName spanName = SpanName.newBuilder().setProject(this.projectId).setTrace(context.getTraceId().toLowerBase16()).setSpan(spanIdHex).build();
        Span.Builder spanBuilder = com.google.devtools.cloudtrace.v2.Span.newBuilder().setName(spanName.toString()).setSpanId(spanIdHex).setDisplayName(StackdriverV2ExporterHandler.toTruncatableStringProto(StackdriverV2ExporterHandler.toDisplayName(spanData.getName(), spanData.getKind()))).setStartTime(StackdriverV2ExporterHandler.toTimestampProto(spanData.getStartTimestamp())).setAttributes(StackdriverV2ExporterHandler.toAttributesProto(spanData.getAttributes(), resourceLabels, fixedAttributes)).setTimeEvents(StackdriverV2ExporterHandler.toTimeEventsProto((SpanData.TimedEvents<Annotation>)spanData.getAnnotations(), (SpanData.TimedEvents<MessageEvent>)spanData.getMessageEvents()));
        Status status = spanData.getStatus();
        if (status != null) {
            spanBuilder.setStatus(StackdriverV2ExporterHandler.toStatusProto(status));
        }
        if ((end = spanData.getEndTimestamp()) != null) {
            spanBuilder.setEndTime(StackdriverV2ExporterHandler.toTimestampProto(end));
        }
        spanBuilder.setLinks(StackdriverV2ExporterHandler.toLinksProto(spanData.getLinks()));
        Integer childSpanCount = spanData.getChildSpanCount();
        if (childSpanCount != null) {
            spanBuilder.setChildSpanCount(Int32Value.newBuilder().setValue(childSpanCount.intValue()).build());
        }
        if (spanData.getParentSpanId() != null && spanData.getParentSpanId().isValid()) {
            spanBuilder.setParentSpanId(spanData.getParentSpanId().toLowerBase16());
        }
        if ((hasRemoteParent = spanData.getHasRemoteParent()) != null) {
            spanBuilder.setSameProcessAsParentSpan(BoolValue.of((hasRemoteParent == false ? 1 : 0) != 0));
        }
        return spanBuilder.build();
    }

    private static Span.TimeEvents toTimeEventsProto(SpanData.TimedEvents<Annotation> annotationTimedEvents, SpanData.TimedEvents<MessageEvent> messageEventTimedEvents) {
        Span.TimeEvents.Builder timeEventsBuilder = Span.TimeEvents.newBuilder();
        timeEventsBuilder.setDroppedAnnotationsCount(annotationTimedEvents.getDroppedEventsCount());
        for (SpanData.TimedEvent annotation : annotationTimedEvents.getEvents()) {
            timeEventsBuilder.addTimeEvent(StackdriverV2ExporterHandler.toTimeAnnotationProto((SpanData.TimedEvent<Annotation>)annotation));
        }
        timeEventsBuilder.setDroppedMessageEventsCount(messageEventTimedEvents.getDroppedEventsCount());
        for (SpanData.TimedEvent networkEvent : messageEventTimedEvents.getEvents()) {
            timeEventsBuilder.addTimeEvent(StackdriverV2ExporterHandler.toTimeMessageEventProto((SpanData.TimedEvent<MessageEvent>)networkEvent));
        }
        return timeEventsBuilder.build();
    }

    private static Span.TimeEvent toTimeAnnotationProto(SpanData.TimedEvent<Annotation> timedEvent) {
        Span.TimeEvent.Builder timeEventBuilder = Span.TimeEvent.newBuilder().setTime(StackdriverV2ExporterHandler.toTimestampProto(timedEvent.getTimestamp()));
        Annotation annotation = (Annotation)timedEvent.getEvent();
        timeEventBuilder.setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(StackdriverV2ExporterHandler.toTruncatableStringProto(annotation.getDescription())).setAttributes(StackdriverV2ExporterHandler.toAttributesBuilderProto(annotation.getAttributes(), 0)).build());
        return timeEventBuilder.build();
    }

    private static Span.TimeEvent toTimeMessageEventProto(SpanData.TimedEvent<MessageEvent> timedEvent) {
        Span.TimeEvent.Builder timeEventBuilder = Span.TimeEvent.newBuilder().setTime(StackdriverV2ExporterHandler.toTimestampProto(timedEvent.getTimestamp()));
        MessageEvent messageEvent = (MessageEvent)timedEvent.getEvent();
        timeEventBuilder.setMessageEvent(Span.TimeEvent.MessageEvent.newBuilder().setId(messageEvent.getMessageId()).setCompressedSizeBytes(messageEvent.getCompressedMessageSize()).setUncompressedSizeBytes(messageEvent.getUncompressedMessageSize()).setType(StackdriverV2ExporterHandler.toMessageEventTypeProto(messageEvent)).build());
        return timeEventBuilder.build();
    }

    private static Span.TimeEvent.MessageEvent.Type toMessageEventTypeProto(MessageEvent messageEvent) {
        if (messageEvent.getType() == MessageEvent.Type.RECEIVED) {
            return Span.TimeEvent.MessageEvent.Type.RECEIVED;
        }
        return Span.TimeEvent.MessageEvent.Type.SENT;
    }

    private static Span.Attributes toAttributesProto(SpanData.Attributes attributes, Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> resourceLabels, Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> fixedAttributes) {
        Span.Attributes.Builder attributesBuilder = StackdriverV2ExporterHandler.toAttributesBuilderProto(attributes.getAttributeMap(), attributes.getDroppedAttributesCount());
        attributesBuilder.putAttributeMap(AGENT_LABEL_KEY, AGENT_LABEL_VALUE);
        for (Map.Entry<String, com.google.devtools.cloudtrace.v2.AttributeValue> entry : resourceLabels.entrySet()) {
            attributesBuilder.putAttributeMap(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, com.google.devtools.cloudtrace.v2.AttributeValue> entry : fixedAttributes.entrySet()) {
            attributesBuilder.putAttributeMap(entry.getKey(), entry.getValue());
        }
        return attributesBuilder.build();
    }

    private static Span.Attributes.Builder toAttributesBuilderProto(Map<String, AttributeValue> attributes, int droppedAttributesCount) {
        Span.Attributes.Builder attributesBuilder = Span.Attributes.newBuilder().setDroppedAttributesCount(droppedAttributesCount);
        for (Map.Entry<String, AttributeValue> label : attributes.entrySet()) {
            com.google.devtools.cloudtrace.v2.AttributeValue value = StackdriverV2ExporterHandler.toAttributeValueProto(label.getValue());
            if (value == null) continue;
            attributesBuilder.putAttributeMap(StackdriverV2ExporterHandler.mapKey(label.getKey()), value);
        }
        return attributesBuilder;
    }

    @VisibleForTesting
    static Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> getResourceLabels(@Nullable Resource resource) {
        if (resource == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, com.google.devtools.cloudtrace.v2.AttributeValue> resourceLabels = new LinkedHashMap<String, com.google.devtools.cloudtrace.v2.AttributeValue>();
        for (Map.Entry entry : resource.getLabels().entrySet()) {
            StackdriverV2ExporterHandler.putToResourceAttributeMap(resourceLabels, (String)entry.getKey(), (String)entry.getValue());
        }
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static void putToResourceAttributeMap(Map<String, com.google.devtools.cloudtrace.v2.AttributeValue> map, String attributeName, String attributeValue) {
        map.put(StackdriverV2ExporterHandler.createResourceLabelKey(attributeName), StackdriverV2ExporterHandler.toStringAttributeValueProto(attributeValue));
    }

    @VisibleForTesting
    static String createResourceLabelKey(String resourceAttribute) {
        return "g.co/r/" + resourceAttribute;
    }

    @VisibleForTesting
    static com.google.devtools.cloudtrace.v2.AttributeValue toStringAttributeValueProto(String value) {
        return com.google.devtools.cloudtrace.v2.AttributeValue.newBuilder().setStringValue(StackdriverV2ExporterHandler.toTruncatableStringProto(value)).build();
    }

    private static String mapKey(String key) {
        if (HTTP_ATTRIBUTE_MAPPING.containsKey((Object)key)) {
            return (String)HTTP_ATTRIBUTE_MAPPING.get((Object)key);
        }
        return key;
    }

    private static com.google.rpc.Status toStatusProto(Status status) {
        Status.Builder statusBuilder = com.google.rpc.Status.newBuilder().setCode(status.getCanonicalCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build();
    }

    private static TruncatableString toTruncatableStringProto(String string) {
        return TruncatableString.newBuilder().setValue(string).setTruncatedByteCount(0).build();
    }

    private static com.google.protobuf.Timestamp toTimestampProto(Timestamp timestamp) {
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    @Nullable
    private static com.google.devtools.cloudtrace.v2.AttributeValue toAttributeValueProto(AttributeValue attributeValue) {
        return (com.google.devtools.cloudtrace.v2.AttributeValue)attributeValue.match(stringAttributeValueFunction, booleanAttributeValueFunction, longAttributeValueFunction, doubleAttributeValueFunction, Functions.returnNull());
    }

    private static Span.Link.Type toLinkTypeProto(Link.Type type) {
        if (type == Link.Type.PARENT_LINKED_SPAN) {
            return Span.Link.Type.PARENT_LINKED_SPAN;
        }
        return Span.Link.Type.CHILD_LINKED_SPAN;
    }

    private static String toDisplayName(String spanName, @Nullable Span.Kind spanKind) {
        if (spanKind == Span.Kind.SERVER && !spanName.startsWith(SERVER_PREFIX)) {
            return SERVER_PREFIX + spanName;
        }
        if (spanKind == Span.Kind.CLIENT && !spanName.startsWith(CLIENT_PREFIX)) {
            return CLIENT_PREFIX + spanName;
        }
        return spanName;
    }

    private static Span.Link toLinkProto(Link link) {
        Preconditions.checkNotNull((Object)link);
        return Span.Link.newBuilder().setTraceId(link.getTraceId().toLowerBase16()).setSpanId(link.getSpanId().toLowerBase16()).setType(StackdriverV2ExporterHandler.toLinkTypeProto(link.getType())).setAttributes(StackdriverV2ExporterHandler.toAttributesBuilderProto(link.getAttributes(), 0)).build();
    }

    private static Span.Links toLinksProto(SpanData.Links links) {
        Span.Links.Builder linksBuilder = Span.Links.newBuilder().setDroppedLinksCount(links.getDroppedLinksCount());
        for (Link link : links.getLinks()) {
            linksBuilder.addLink(StackdriverV2ExporterHandler.toLinkProto(link));
        }
        return linksBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Collection<SpanData> spanDataList) {
        Span span = tracer.spanBuilder(EXPORT_STACKDRIVER_TRACES).setSampler(probabilitySampler).setRecordEvents(true).startSpan();
        Scope scope = tracer.withSpan(span);
        try {
            ArrayList<com.google.devtools.cloudtrace.v2.Span> spans = new ArrayList<com.google.devtools.cloudtrace.v2.Span>(spanDataList.size());
            for (SpanData spanData : spanDataList) {
                spans.add(this.generateSpan(spanData, RESOURCE_LABELS, this.fixedAttributes));
            }
            this.traceServiceClient.batchWriteSpans(this.projectName, spans);
        }
        finally {
            scope.close();
            span.end(END_SPAN_OPTIONS);
        }
    }
}

