/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.assign;

import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDefinition;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackSize;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;

public class TypeCasting
implements StackManipulation {
    private final TypeDescription typeDescription;

    protected TypeCasting(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public static StackManipulation to(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type: " + typeDefinition);
        }
        return new TypeCasting(typeDefinition.asErasure());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(192, this.typeDescription.getInternalName());
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeCasting)) {
            return false;
        }
        TypeCasting other = (TypeCasting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TypeDescription this$typeDescription = this.typeDescription;
        TypeDescription other$typeDescription = other.typeDescription;
        return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypeCasting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeDescription $typeDescription = this.typeDescription;
        result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
        return result;
    }
}

