/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.subclass;

import io.opencensus.contrib.agent.deps.bytebuddy.ClassFileVersion;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDefinition;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.scaffold.MethodGraph;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;

public class SubclassImplementationTarget
extends Implementation.Target.AbstractBase {
    protected final OriginTypeResolver originTypeResolver;

    protected SubclassImplementationTarget(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, Implementation.Target.AbstractBase.DefaultMethodInvocation defaultMethodInvocation, OriginTypeResolver originTypeResolver) {
        super(instrumentedType, methodGraph, defaultMethodInvocation);
        this.originTypeResolver = originTypeResolver;
    }

    @Override
    public Implementation.SpecialMethodInvocation invokeSuper(MethodDescription.SignatureToken token) {
        return token.getName().equals("<init>") ? this.invokeConstructor(token) : this.invokeMethod(token);
    }

    private Implementation.SpecialMethodInvocation invokeConstructor(MethodDescription.SignatureToken token) {
        TypeDescription.Generic superClass = this.instrumentedType.getSuperClass();
        MethodList.Empty candidates = superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.hasSignature(token).and(ElementMatchers.isVisibleTo(this.instrumentedType)));
        return candidates.size() == 1 ? Implementation.SpecialMethodInvocation.Simple.of((MethodDescription)candidates.getOnly(), this.instrumentedType.getSuperClass().asErasure()) : Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
    }

    private Implementation.SpecialMethodInvocation invokeMethod(MethodDescription.SignatureToken token) {
        MethodGraph.Node methodNode = this.methodGraph.getSuperClassGraph().locate(token);
        return methodNode.getSort().isUnique() ? Implementation.SpecialMethodInvocation.Simple.of(methodNode.getRepresentative(), this.instrumentedType.getSuperClass().asErasure()) : Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
    }

    @Override
    public TypeDefinition getOriginType() {
        return this.originTypeResolver.identify(this.instrumentedType);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubclassImplementationTarget)) {
            return false;
        }
        SubclassImplementationTarget other = (SubclassImplementationTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OriginTypeResolver this$originTypeResolver = this.originTypeResolver;
        OriginTypeResolver other$originTypeResolver = other.originTypeResolver;
        return !(this$originTypeResolver == null ? other$originTypeResolver != null : !((Object)((Object)this$originTypeResolver)).equals((Object)other$originTypeResolver));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubclassImplementationTarget;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        OriginTypeResolver $originTypeResolver = this.originTypeResolver;
        result = result * 59 + ($originTypeResolver == null ? 43 : ((Object)((Object)$originTypeResolver)).hashCode());
        return result;
    }

    public static enum Factory implements Implementation.Target.Factory
    {
        SUPER_CLASS(OriginTypeResolver.SUPER_CLASS),
        LEVEL_TYPE(OriginTypeResolver.LEVEL_TYPE);

        private final OriginTypeResolver originTypeResolver;

        private Factory(OriginTypeResolver originTypeResolver) {
            this.originTypeResolver = originTypeResolver;
        }

        @Override
        public Implementation.Target make(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, ClassFileVersion classFileVersion) {
            return new SubclassImplementationTarget(instrumentedType, methodGraph, Implementation.Target.AbstractBase.DefaultMethodInvocation.of(classFileVersion), this.originTypeResolver);
        }
    }

    public static enum OriginTypeResolver {
        SUPER_CLASS{

            @Override
            protected TypeDefinition identify(TypeDescription typeDescription) {
                return typeDescription.getSuperClass();
            }
        }
        ,
        LEVEL_TYPE{

            @Override
            protected TypeDefinition identify(TypeDescription typeDescription) {
                return typeDescription;
            }
        };


        protected abstract TypeDefinition identify(TypeDescription var1);
    }
}

