/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.instrumentation;

import com.google.errorprone.annotations.MustBeClosed;
import io.opencensus.contrib.agent.bootstrap.TraceStrategy;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.samplers.Samplers;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;

final class TraceStrategyImpl
implements TraceStrategy {
    TraceStrategyImpl() {
    }

    @MustBeClosed
    public Closeable startScopedSpan(String spanName) {
        Preconditions.checkNotNull(spanName, "spanName");
        return Tracing.getTracer().spanBuilder(spanName).setSampler(Samplers.alwaysSample()).setRecordEvents(true).startScopedSpan();
    }

    public void endScope(Closeable scope, @Nullable Throwable throwable) {
        Preconditions.checkNotNull(scope, "scope");
        if (throwable != null) {
            Tracing.getTracer().getCurrentSpan().setStatus(Status.UNKNOWN.withDescription(throwable.getMessage() == null ? throwable.getClass().getSimpleName() : throwable.getMessage()));
        }
        try {
            scope.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

