/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.instrumentation;

import io.grpc.Context;
import io.opencensus.contrib.agent.bootstrap.ContextStrategy;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.cache.Cache;
import io.opencensus.contrib.agent.deps.guava.cache.CacheBuilder;

final class ContextStrategyImpl
implements ContextStrategy {
    private final Cache<Thread, Context> savedContexts = CacheBuilder.newBuilder().weakKeys().build();

    ContextStrategyImpl() {
    }

    public Runnable wrapInCurrentContext(Runnable runnable) {
        return Context.current().wrap(runnable);
    }

    public void saveContextForThread(Thread thread) {
        this.savedContexts.put(thread, Context.current());
    }

    public void attachContextForThread(Thread thread) {
        Context context;
        if (Thread.currentThread() == thread && (context = this.savedContexts.getIfPresent(thread)) != null) {
            this.savedContexts.invalidate(thread);
            Preconditions.checkNotNull(context.attach(), "context.attach()");
        }
    }
}

