/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.collect;

import io.opencensus.contrib.agent.deps.guava.annotations.GwtCompatible;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.collect.ForwardingCollection;
import io.opencensus.contrib.agent.deps.guava.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@NullableDecl Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, Preconditions.checkNotNull(collection));
    }

    protected boolean standardEquals(@NullableDecl Object object) {
        return Sets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

