/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.collect;

import io.opencensus.contrib.agent.deps.guava.annotations.GwtCompatible;
import io.opencensus.contrib.agent.deps.guava.collect.UnmodifiableIterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    @NullableDecl
    private T nextOrNull;

    protected AbstractSequentialIterator(@NullableDecl T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

