/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent;

import io.opencensus.contrib.agent.AgentBuilderListener;
import io.opencensus.contrib.agent.Resources;
import io.opencensus.contrib.agent.Settings;
import io.opencensus.contrib.agent.bootstrap.ContextStrategy;
import io.opencensus.contrib.agent.bootstrap.ContextTrampoline;
import io.opencensus.contrib.agent.deps.bytebuddy.agent.builder.AgentBuilder;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.instrumentation.Instrumenter;
import java.lang.instrument.Instrumentation;
import java.util.ServiceLoader;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public final class AgentMain {
    private static final Logger logger = Logger.getLogger(AgentMain.class.getName());

    private AgentMain() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Exception {
        Preconditions.checkNotNull(instrumentation, "instrumentation");
        logger.fine("Initializing.");
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(Resources.getResourceAsTempFile("bootstrap.jar")));
        AgentMain.checkLoadedByBootstrapClassloader(ContextTrampoline.class);
        AgentMain.checkLoadedByBootstrapClassloader(ContextStrategy.class);
        Settings settings = Settings.load();
        AgentBuilder agentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(new AgentBuilderListener()).ignore(ElementMatchers.none());
        for (Instrumenter instrumenter : ServiceLoader.load(Instrumenter.class)) {
            agentBuilder = instrumenter.instrument(agentBuilder, settings);
        }
        agentBuilder.installOn(instrumentation);
        logger.fine("Initialized.");
    }

    private static void checkLoadedByBootstrapClassloader(Class<?> clazz) {
        Preconditions.checkState(clazz.getClassLoader() == null, "%s must be loaded by the bootstrap classloader", clazz);
    }
}

