/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opencensus.contrib.agent.deps.guava.annotations.Beta;
import io.opencensus.contrib.agent.deps.guava.annotations.GwtCompatible;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.base.VerifyException;
import javax.annotation.Nullable;

@Beta
@GwtCompatible
public final class Verify {
    public static void verify(boolean expression) {
        if (!expression) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new VerifyException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference) {
        return Verify.verifyNotNull(reference, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        Verify.verify(reference != null, errorMessageTemplate, errorMessageArgs);
        return reference;
    }

    private Verify() {
    }
}

