/*
 * Decompiled with CFR 0.152.
 */
package com.squid.core.jdbc.vendor.postgresql.render;

import com.squid.core.database.model.DatabaseProduct;
import com.squid.core.domain.operators.AggregateOperatorDefinition;
import com.squid.core.domain.operators.CoVarPopOperatorDefinition;
import com.squid.core.domain.operators.OperatorDefinition;
import com.squid.core.domain.operators.StdevPopOperatorDefinition;
import com.squid.core.jdbc.vendor.postgresql.render.ANSIZeroIfNullFeatureSupport;
import com.squid.core.jdbc.vendor.postgresql.render.CoVarRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.MonthsBetweenRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.MySQLPosgresCoshOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.MySQLPosgresSinhOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.MySQLPosgresTanhOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PosStringRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresAvgRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresDateAddSubOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresDateEpochOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresDateTruncateOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresExtractOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresRandOperatorRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.PostgresSQLSkin;
import com.squid.core.jdbc.vendor.postgresql.render.SubStringRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.VarStdevRenderer;
import com.squid.core.jdbc.vendor.postgresql.render.WidthBucketRenderer;
import com.squid.core.sql.db.features.IGroupingSetSupport;
import com.squid.core.sql.db.render.AddMonthsAsIntervalOperatorRenderer;
import com.squid.core.sql.db.render.DateAddSubOperatorRenderer;
import com.squid.core.sql.db.render.MetatdataSearchFeatureSupport;
import com.squid.core.sql.db.render.OperatorRenderer;
import com.squid.core.sql.db.render.OrderedAnalyticOperatorRenderer;
import com.squid.core.sql.db.render.RankOperatorRenderer;
import com.squid.core.sql.db.templates.DefaultJDBCSkin;
import com.squid.core.sql.db.templates.DefaultSkinProvider;
import com.squid.core.sql.db.templates.ISkinProvider;
import com.squid.core.sql.db.templates.SkinRegistry;
import com.squid.core.sql.render.ISkinFeatureSupport;
import com.squid.core.sql.render.SQLSkin;
import com.squid.core.sql.render.ZeroIfNullFeatureSupport;
import com.squid.core.sql.statements.SelectStatement;
import java.util.List;

public class PostgresSkinProvider
extends DefaultSkinProvider {
    private static final ZeroIfNullFeatureSupport zeroIfNull = new ANSIZeroIfNullFeatureSupport();
    private SelectStatement.SampleFeatureSupport SAMPLE_SUPPORT = new SelectStatement.SampleFeatureSupport(){

        public boolean isCountSupported() {
            return false;
        }

        public boolean isPercentageSupported() {
            return true;
        }
    };
    private MetatdataSearchFeatureSupport METADATA_SEARCH_SUPPORT = new MetatdataSearchFeatureSupport(){

        public String createTableSearch(List<String> schemas, String tableName, boolean isCaseSensitive) {
            StringBuilder sqlCode = new StringBuilder();
            sqlCode.append("SELECT  N.NSPNAME AS SCHEMANAME, C.RELNAME AS TABLENAME, D.DESCRIPTION");
            sqlCode.append(CR_LF);
            sqlCode.append(" FROM PG_CLASS C");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT JOIN PG_NAMESPACE N ON N.OID = C.RELNAMESPACE");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT JOIN PG_TABLESPACE T ON T.OID = C.RELTABLESPACE");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT OUTER JOIN PG_DESCRIPTION D ON D.OBJOID=C.RELFILENODE AND D.OBJSUBID=0");
            sqlCode.append(CR_LF);
            sqlCode.append(" WHERE C.RELKIND = 'r'::\"char\"");
            sqlCode.append(CR_LF);
            sqlCode.append(" AND N.NSPNAME NOT IN ('INFORMATION_SCHEMA','PG_CATALOG')");
            sqlCode.append(CR_LF);
            sqlCode.append(" AND N.NSPNAME IN (" + this.getGroupSchemaNames(schemas) + ")");
            sqlCode.append(CR_LF);
            sqlCode.append(" GROUP BY N.NSPNAME, C.RELFILENODE, C.RELNAME, D.DESCRIPTION");
            sqlCode.append(CR_LF);
            sqlCode.append(" HAVING (" + this.applyCaseSensitive("C.RELNAME", isCaseSensitive) + " LIKE " + this.applyCaseSensitive(tableName, isCaseSensitive) + " OR " + this.applyCaseSensitive("D.DESCRIPTION", isCaseSensitive) + " LIKE " + this.applyCaseSensitive(tableName, isCaseSensitive) + ")");
            sqlCode.append(CR_LF);
            sqlCode.append(" ORDER BY N.NSPNAME, C.RELNAME");
            return sqlCode.toString();
        }

        public String createColumnSearch(List<String> schemas, String tableName, String columnName, boolean isCaseSensitive) {
            StringBuilder sqlCode = new StringBuilder();
            sqlCode.append("SELECT N.NSPNAME AS SCHEMANAME, C.RELNAME, ATTNAME, DESCRIPTION");
            sqlCode.append(CR_LF);
            sqlCode.append(" FROM PG_CLASS C");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT JOIN PG_ATTRIBUTE A ON C.OID = A.ATTRELID");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT JOIN PG_NAMESPACE N ON N.OID = C.RELNAMESPACE");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT OUTER JOIN PG_DESCRIPTION ON (OBJOID = C.OID) AND (ATTNUM = OBJSUBID)");
            sqlCode.append(CR_LF);
            sqlCode.append(" WHERE A.ATTNUM > 0");
            sqlCode.append(CR_LF);
            sqlCode.append(" AND C.RELFILENODE IN");
            sqlCode.append(CR_LF);
            sqlCode.append(" (SELECT  C.RELFILENODE");
            sqlCode.append(CR_LF);
            sqlCode.append(" FROM PG_CLASS C");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT JOIN PG_NAMESPACE N ON N.OID = C.RELNAMESPACE");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT JOIN PG_TABLESPACE T ON T.OID = C.RELTABLESPACE");
            sqlCode.append(CR_LF);
            sqlCode.append(" LEFT OUTER JOIN PG_DESCRIPTION D ON D.OBJOID=C.RELFILENODE AND D.OBJSUBID=0");
            sqlCode.append(CR_LF);
            sqlCode.append(" WHERE C.RELKIND = 'r'::\"char\"");
            sqlCode.append(CR_LF);
            sqlCode.append(" AND N.NSPNAME NOT IN ('INFORMATION_SCHEMA','PG_CATALOG')");
            sqlCode.append(CR_LF);
            sqlCode.append(" AND N.NSPNAME IN (" + this.getGroupSchemaNames(schemas) + ")");
            sqlCode.append(CR_LF);
            sqlCode.append(" GROUP BY C.RELFILENODE, C.RELNAME, D.DESCRIPTION");
            if (tableName != null) {
                sqlCode.append(CR_LF);
                sqlCode.append(" HAVING (" + this.applyCaseSensitive("C.RELNAME", isCaseSensitive) + " LIKE " + this.applyCaseSensitive(tableName, isCaseSensitive) + " OR " + this.applyCaseSensitive("D.DESCRIPTION", isCaseSensitive) + " LIKE " + this.applyCaseSensitive(tableName, isCaseSensitive) + "))");
            } else {
                sqlCode.append(")");
            }
            sqlCode.append(CR_LF);
            sqlCode.append(" GROUP BY  N.NSPNAME, C.RELNAME, ATTNAME, DESCRIPTION");
            sqlCode.append(CR_LF);
            sqlCode.append(" HAVING (" + this.applyCaseSensitive("ATTNAME", isCaseSensitive) + " LIKE " + this.applyCaseSensitive(columnName, isCaseSensitive) + " OR " + this.applyCaseSensitive("DESCRIPTION", isCaseSensitive) + " LIKE " + this.applyCaseSensitive(columnName, isCaseSensitive) + ")");
            sqlCode.append(CR_LF);
            sqlCode.append(" ORDER BY N.NSPNAME, C.RELNAME, ATTNAME");
            return sqlCode.toString();
        }
    };

    public PostgresSkinProvider() {
        this.registerOperatorRender("com.sodad.domain.operator.density.EQWBUCKET", (OperatorRenderer)new WidthBucketRenderer());
        this.registerOperatorRender("com.squid.domain.operator.string.POSITION", (OperatorRenderer)new PosStringRenderer());
        this.registerOperatorRender("com.squid.domain.operator.string.SUBSTRING", (OperatorRenderer)new SubStringRenderer());
        this.registerOperatorRender(OperatorDefinition.getExtendedId((int)9), (OperatorRenderer)new OrderedAnalyticOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.operator.maths.RAND", (OperatorRenderer)new PostgresRandOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.operator.maths.SINH", (OperatorRenderer)new MySQLPosgresSinhOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.operator.maths.COSH", (OperatorRenderer)new MySQLPosgresCoshOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.operator.maths.TANH", (OperatorRenderer)new MySQLPosgresTanhOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.operator.date.DATE_ADD", (OperatorRenderer)new PostgresDateAddSubOperatorRenderer(DateAddSubOperatorRenderer.OperatorType.ADD));
        this.registerOperatorRender("com.squid.domain.operator.date.DATE_SUB", (OperatorRenderer)new PostgresDateAddSubOperatorRenderer(DateAddSubOperatorRenderer.OperatorType.SUB));
        this.registerOperatorRender("com.squid.domain.operator.date.ADD_MONTHS", (OperatorRenderer)new AddMonthsAsIntervalOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.operator.date.MONTHS_BETWEEN", (OperatorRenderer)new MonthsBetweenRenderer());
        this.registerOperatorRender("com.squid.domain.operator.extract.DAY_OF_WEEK", (OperatorRenderer)new PostgresExtractOperatorRenderer("DOW"));
        this.registerOperatorRender("com.squid.domain.operator.extract.DAY_OF_YEAR", (OperatorRenderer)new PostgresExtractOperatorRenderer("DOY"));
        this.registerOperatorRender("com.squid.domain.operator.date.FROM_UNIXTIME", (OperatorRenderer)new PostgresDateEpochOperatorRenderer(0));
        this.registerOperatorRender("com.squid.domain.operator.date.TO_UNIXTIME", (OperatorRenderer)new PostgresDateEpochOperatorRenderer(1));
        this.registerOperatorRender("com.squid.domain.operator.date.DATE_TRUNCATE", (OperatorRenderer)new PostgresDateTruncateOperatorRenderer());
        this.registerOperatorRender(StdevPopOperatorDefinition.getExtendedId((int)12), (OperatorRenderer)new VarStdevRenderer());
        this.registerOperatorRender(StdevPopOperatorDefinition.getExtendedId((int)28), (OperatorRenderer)new VarStdevRenderer());
        this.registerOperatorRender(StdevPopOperatorDefinition.getExtendedId((int)29), (OperatorRenderer)new VarStdevRenderer());
        this.registerOperatorRender(StdevPopOperatorDefinition.getExtendedId((int)30), (OperatorRenderer)new VarStdevRenderer());
        this.registerOperatorRender(CoVarPopOperatorDefinition.getExtendedId((int)31), (OperatorRenderer)new CoVarRenderer());
        this.registerOperatorRender(AggregateOperatorDefinition.getExtendedId((int)8), (OperatorRenderer)new PostgresAvgRenderer());
        this.registerOperatorRender("com.squid.domain.model.operators.RANK", (OperatorRenderer)new RankOperatorRenderer());
        this.registerOperatorRender("com.squid.domain.model.operators.ROWNUMBER", (OperatorRenderer)new RankOperatorRenderer());
    }

    public double computeAccuracy(DatabaseProduct product) {
        try {
            if (product != null) {
                if ("PostgreSQL".equalsIgnoreCase(product.getProductName())) {
                    return 2.0;
                }
                return -1.0;
            }
            return -1.0;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public SQLSkin createSkin(DatabaseProduct product) {
        return new PostgresSQLSkin((ISkinProvider)this, product);
    }

    public ISkinFeatureSupport getFeatureSupport(DefaultJDBCSkin skin, String featureID) {
        if (featureID == "SelectStatement.GROUPBY.ALIAS") {
            return ISkinFeatureSupport.IS_SUPPORTED;
        }
        if (featureID == "SelectStatement.SAMPLE") {
            return this.SAMPLE_SUPPORT;
        }
        if (featureID == "ZeorIfNullFeatureSupport") {
            return zeroIfNull;
        }
        if (featureID == "ForeignKeyFeature") {
            return ISkinFeatureSupport.IS_SUPPORTED;
        }
        if (featureID == "PrimaryKeyFeature") {
            return ISkinFeatureSupport.IS_SUPPORTED;
        }
        if (featureID == "MetadataSearchFeatureID") {
            return this.METADATA_SEARCH_SUPPORT;
        }
        if (featureID == "GroupingSetFeature") {
            return IGroupingSetSupport.IS_NOT_SUPPORTED;
        }
        if (featureID == "autocommit") {
            return ISkinFeatureSupport.IS_NOT_SUPPORTED;
        }
        return super.getFeatureSupport(skin, featureID);
    }

    public String getSkinPrefix(DatabaseProduct product) {
        return "postgresql";
    }

    public ISkinProvider getParentSkinProvider() {
        return SkinRegistry.INSTANCE.findSkinProvider(DefaultSkinProvider.class);
    }
}

