/*
 * Decompiled with CFR 0.152.
 */
package com.squid.core.jdbc.vendor.postgresql.render;

import com.squid.core.database.model.DatabaseProduct;
import com.squid.core.database.model.Table;
import com.squid.core.domain.IDomain;
import com.squid.core.domain.operators.ExtendedType;
import com.squid.core.domain.operators.OperatorDefinition;
import com.squid.core.jdbc.vendor.postgresql.render.SamplingPiece;
import com.squid.core.sql.db.render.FromTablePiece;
import com.squid.core.sql.db.templates.DefaultJDBCSkin;
import com.squid.core.sql.db.templates.ISkinProvider;
import com.squid.core.sql.render.DelegateSamplingDecorator;
import com.squid.core.sql.render.ISamplingDecorator;
import com.squid.core.sql.render.OperatorPiece;
import com.squid.core.sql.render.RenderingException;
import com.squid.core.sql.render.SQLSkin;
import java.io.IOException;

public class PostgresSQLSkin
extends DefaultJDBCSkin {
    public PostgresSQLSkin(ISkinProvider provider, DatabaseProduct product) {
        super(provider, product);
    }

    protected void initFormat() {
        super.initFormat();
        this.setIdentifier_quote("\"");
        this.setLiteral_quote("'");
    }

    public String overrideTemplateID(String templateID) {
        return super.overrideTemplateID(templateID);
    }

    public String getToken(int token) throws RenderingException {
        switch (token) {
            default: 
        }
        return super.getToken(token);
    }

    public ISamplingDecorator createSamplingDecorator(DelegateSamplingDecorator sampling) {
        return new SamplingPiece(sampling);
    }

    protected String render(SQLSkin skin, FromTablePiece piece) throws RenderingException, IOException {
        String render = "";
        Table table = piece.getTable();
        if (table == null) {
            throw new RenderingException("table definition is null");
        }
        if (piece.getSamplingDecorator() != null) {
            render = render + " ( select * from ";
            if (table.getSchema() != null && !table.getSchema().isNullSchema()) {
                render = render + skin.quoteSchemaIdentifier(table.getSchema());
                render = render + ".";
            }
            render = render + skin.quoteTableIdentifier(table);
            render = piece.getSamplingDecorator().getMode() == 1 ? render + " where random()<" + piece.getSamplingDecorator().getPercent() / 100.0 : render + " limit " + piece.getSamplingDecorator().getSize();
            render = render + " ) as " + piece.getAlias();
        } else {
            if (table.getSchema() != null && !table.getSchema().isNullSchema()) {
                render = render + skin.quoteSchemaIdentifier(table.getSchema());
                render = render + ".";
            }
            render = render + skin.quoteTableIdentifier(table);
            render = render + " " + piece.getAlias();
        }
        render = render + this.renderJoinDecorator(skin, piece);
        return render;
    }

    public String quoteConstant(Object value, IDomain domain) {
        if (domain.isInstanceOf(IDomain.BOOLEAN)) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "true" : "false";
            }
            if (value instanceof Double && Math.floor((Double)value) == (Double)value) {
                return new Integer(((Double)value).intValue()).toString();
            }
            return value.toString();
        }
        return super.quoteConstant(value, domain);
    }

    public ExtendedType createExtendedType(IDomain domain, int dataType, String format, int size, int precision) {
        if (dataType != 0) {
            return new ExtendedType(domain, dataType, precision, size);
        }
        return new ExtendedType(domain, this.computeDataType(domain, dataType, format, size, precision), precision, size);
    }

    protected int computeDataType(IDomain domain, int dataType, String format, int size, int precision) {
        if (domain.isInstanceOf(IDomain.NUMERIC)) {
            if (precision == 0) {
                if (size <= 2) {
                    return 5;
                }
                if (size <= 4) {
                    return 4;
                }
                if (size <= 8) {
                    return -5;
                }
                return 2;
            }
            if (precision > 0) {
                return 2;
            }
            if (size <= 6) {
                return 7;
            }
            return 8;
        }
        if (domain.isInstanceOf(IDomain.STRING)) {
            if (size > 5) {
                return 12;
            }
            return 1;
        }
        if (domain.isInstanceOf(IDomain.TIMESTAMP)) {
            return 93;
        }
        if (domain.isInstanceOf(IDomain.DATE)) {
            if (format != null && format.contains("HH")) {
                return 93;
            }
            return 91;
        }
        if (domain.isInstanceOf(IDomain.TIME)) {
            return 92;
        }
        return 0;
    }

    public String getTypeName(int SQLType2) {
        switch (SQLType2) {
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 3: {
                return "NUMERIC";
            }
        }
        return super.getTypeName(SQLType2);
    }

    public String getTypeDefinition(ExtendedType type) {
        if (type == null) {
            return "NULL";
        }
        switch (type.getDataType()) {
            case 91: 
            case 92: 
            case 93: {
                return this.getTypeName(type.getDataType());
            }
            case -12345: {
                return "INTERVAL";
            }
            case -6: {
                return "SMALLINT";
            }
        }
        if (type.getName().equalsIgnoreCase("nvarchar")) {
            return "VARCHAR(" + type.getSize() + ")";
        }
        if (type.getName().equalsIgnoreCase("nchar")) {
            return "CHAR(" + type.getSize() + ")";
        }
        return super.getTypeDefinition(type);
    }

    public String render(SQLSkin skin, OperatorPiece piece, OperatorDefinition opDef, String[] args) throws RenderingException {
        if (opDef.getId() == 24) {
            return opDef.prettyPrint("MOD", 1, args, true);
        }
        if (opDef.getId() == 1) {
            return opDef.prettyPrint("||", 2, args, true);
        }
        return super.render(skin, piece, opDef, args);
    }

    public String fullyQualified(Table table) {
        String res = "";
        if (table.getSchema() != null && !table.getSchema().isNullSchema()) {
            res = res + this.quoteSchemaIdentifier(table.getSchema()) + ".";
        }
        res = res + this.quoteTableIdentifier(table);
        return res;
    }
}

