/*
 * Decompiled with CFR 0.152.
 */
package com.squid.core.jdbc.vendor.postgresql.render;

import com.squid.core.domain.operators.OperatorDefinition;
import com.squid.core.sql.db.render.ExtractOperatorRenderer;
import com.squid.core.sql.render.OperatorPiece;
import com.squid.core.sql.render.RenderingException;
import com.squid.core.sql.render.SQLSkin;

public class PostgresExtractOperatorRenderer
extends ExtractOperatorRenderer {
    public PostgresExtractOperatorRenderer(String mode) {
        super(mode);
    }

    public String prettyPrint(SQLSkin skin, OperatorPiece piece, OperatorDefinition opDef, String[] args) throws RenderingException {
        if (args.length != 1) {
            throw new RenderingException("invalid EXTRACT operator");
        }
        if (opDef.getExtendedID() == "com.squid.domain.operator.extract.DAY_OF_WEEK") {
            String cast = "CAST(" + super.prettyPrint(skin, piece, opDef, args) + " AS INTEGER)";
            return "CASE WHEN " + cast + " = 0 THEN 7 ELSE " + cast + " END";
        }
        if (opDef.getExtendedID() == "com.squid.domain.operator.extract.DAY_OF_YEAR") {
            return "CAST(" + super.prettyPrint(skin, piece, opDef, args) + " AS INTEGER)";
        }
        return super.prettyPrint(skin, piece, opDef, args);
    }
}

