/*
 * Decompiled with CFR 0.152.
 */
package com.squid.core.jdbc.vendor.postgresql;

import com.squid.core.database.impl.DataSourceReliable;
import com.squid.core.database.metadata.VendorMetadataSupport;
import com.squid.core.database.model.DatabaseProduct;
import com.squid.core.database.statistics.IDatabaseStatistics;
import com.squid.core.jdbc.formatter.DataFormatter;
import com.squid.core.jdbc.formatter.IJDBCDataFormatter;
import com.squid.core.jdbc.vendor.DefaultVendorSupport;
import com.squid.core.jdbc.vendor.postgresql.PostgresqlJDBCDataFormatter;
import com.squid.core.jdbc.vendor.postgresql.PostgresqlMetadataSupport;
import com.squid.core.jdbc.vendor.postgresql.PostgresqlStatistics;
import java.io.IOException;
import java.sql.Connection;
import java.util.Properties;

public class PostgresqlVendorSupport
extends DefaultVendorSupport {
    public static final String VENDOR_ID = "PostgreSQL";
    public static final VendorMetadataSupport METADATA = new PostgresqlMetadataSupport();
    private Properties properties;

    public String getVendorId() {
        return VENDOR_ID;
    }

    public String getVendorVersion() {
        try {
            this.properties = new Properties();
            this.properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("application.properties"));
            return this.properties.getProperty("application.version");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "-1";
        }
    }

    public boolean isSupported(DatabaseProduct product) {
        return VENDOR_ID.equals(product.getProductName());
    }

    public IJDBCDataFormatter createFormatter(DataFormatter formatter, Connection connection) {
        return new PostgresqlJDBCDataFormatter(formatter, connection);
    }

    public IDatabaseStatistics createDatabaseStatistics(DataSourceReliable ds) {
        return new PostgresqlStatistics(ds);
    }

    public VendorMetadataSupport getVendorMetadataSupport() {
        return METADATA;
    }
}

