/*
 * Decompiled with CFR 0.152.
 */
package com.squid.core.jdbc.vendor.postgresql;

import com.squid.core.database.impl.DataSourceReliable;
import com.squid.core.database.model.Column;
import com.squid.core.database.model.Schema;
import com.squid.core.database.model.Table;
import com.squid.core.database.statistics.ColumnStatistics;
import com.squid.core.database.statistics.DatabaseStatistics;
import com.squid.core.database.statistics.ObjectStatistics;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlStatistics
extends DatabaseStatistics {
    static final Logger logger = LoggerFactory.getLogger(PostgresqlStatistics.class);

    public PostgresqlStatistics(DataSourceReliable ds) {
        super(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeTablesStatistics(Schema schema, Connection connection) throws ExecutionException {
        try (Statement statement = null;){
            statement = connection.createStatement();
            String sql = "select relname, reltuples from pg_class left join pg_namespace on relnamespace=pg_namespace.oid where nspname='" + schema.getName() + "'";
            ResultSet resultset = statement.executeQuery(sql);
            while (resultset.next()) {
                String relname = resultset.getString(1);
                float reltuples = resultset.getFloat(2);
                Table table = schema.findTable(relname);
                if (table == null) continue;
                this.putStatistics(table, new ObjectStatistics(reltuples));
            }
        }
        catch (SQLException e) {
            logger.info(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeColumnsStatistics(Table table, Connection connection) throws ExecutionException {
        try (Statement statement = null;){
            ObjectStatistics tableStatistics = this.getStatistics(table, connection);
            float tableSize = tableStatistics != null ? tableStatistics.getSize() : -1.0f;
            statement = connection.createStatement();
            String sql = "select attname, n_distinct from pg_stats where schemaname='" + table.getSchema().getName() + "' and tablename='" + table.getName() + "'";
            ResultSet resultset = statement.executeQuery(sql);
            while (resultset.next()) {
                String attname = resultset.getString(1);
                float n_distinct = resultset.getFloat(2);
                Column col = table.findColumnByName(attname);
                if (col == null) continue;
                float stats = n_distinct > 0.0f ? n_distinct : -n_distinct * tableSize;
                this.putStatistics(col, new ColumnStatistics(stats));
            }
        }
        catch (SQLException e) {
            logger.info(e.getLocalizedMessage());
        }
    }
}

