/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.processor;

import io.openapiprocessor.api.v1.OpenApiProcessor;
import io.openapiprocessor.core.converter.ApiConverter;
import io.openapiprocessor.core.converter.ApiOptions;
import io.openapiprocessor.core.framework.Framework;
import io.openapiprocessor.core.framework.FrameworkAnnotations;
import io.openapiprocessor.core.model.Api;
import io.openapiprocessor.core.parser.OpenApi;
import io.openapiprocessor.core.parser.Parser;
import io.openapiprocessor.core.processor.MappingConverter;
import io.openapiprocessor.core.processor.MappingReader;
import io.openapiprocessor.core.processor.mapping.MappingVersion;
import io.openapiprocessor.core.processor.mapping.v1.Mapping;
import io.openapiprocessor.core.writer.java.ApiWriter;
import io.openapiprocessor.core.writer.java.BeanValidationFactory;
import io.openapiprocessor.core.writer.java.DataTypeWriter;
import io.openapiprocessor.core.writer.java.DefaultImportFilter;
import io.openapiprocessor.core.writer.java.ImportFilter;
import io.openapiprocessor.core.writer.java.InterfaceWriter;
import io.openapiprocessor.core.writer.java.MappingAnnotationWriter;
import io.openapiprocessor.core.writer.java.MethodWriter;
import io.openapiprocessor.core.writer.java.ParameterAnnotationWriter;
import io.openapiprocessor.core.writer.java.SimpleWriter;
import io.openapiprocessor.core.writer.java.StringEnumWriter;
import io.openapiprocessor.spring.processor.SpringFramework;
import io.openapiprocessor.spring.processor.SpringFrameworkAnnotations;
import io.openapiprocessor.spring.writer.java.HeaderWriter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/openapiprocessor/spring/processor/SpringProcessor;", "Lio/openapiprocessor/api/OpenApiProcessor;", "Lio/openapiprocessor/api/v1/OpenApiProcessor;", "()V", "log", "Lorg/slf4j/Logger;", "convertOptions", "Lio/openapiprocessor/core/converter/ApiOptions;", "processorOptions", "", "", "getName", "run", "", "", "openapi-processor-spring"})
public final class SpringProcessor
implements io.openapiprocessor.api.OpenApiProcessor,
OpenApiProcessor {
    private final Logger log;

    @NotNull
    public String getName() {
        return "spring";
    }

    public void run(@NotNull Map<String, ?> processorOptions) {
        Intrinsics.checkNotNullParameter(processorOptions, (String)"processorOptions");
        try {
            Parser parser = new Parser();
            OpenApi openapi = parser.parse(processorOptions);
            if (processorOptions.get("showWarnings") != null) {
                openapi.printWarnings();
            }
            SpringFramework framework = new SpringFramework();
            SpringFrameworkAnnotations annotations = new SpringFrameworkAnnotations();
            ApiOptions options = this.convertOptions(processorOptions);
            ApiConverter cv = new ApiConverter(options, (Framework)framework);
            Api api = cv.convert(openapi);
            HeaderWriter headerWriter = new HeaderWriter();
            BeanValidationFactory beanValidationFactory = new BeanValidationFactory();
            ApiWriter writer = new ApiWriter(options, new InterfaceWriter(options, (SimpleWriter)headerWriter, new MethodWriter(options, (MappingAnnotationWriter)new io.openapiprocessor.spring.writer.java.MappingAnnotationWriter(), (ParameterAnnotationWriter)new io.openapiprocessor.spring.writer.java.ParameterAnnotationWriter(annotations), beanValidationFactory, null, 16, null), (FrameworkAnnotations)annotations, beanValidationFactory, (ImportFilter)new DefaultImportFilter()), new DataTypeWriter(options, (SimpleWriter)headerWriter, beanValidationFactory), new StringEnumWriter((SimpleWriter)headerWriter), true);
            writer.write(api);
        }
        catch (Exception e) {
            this.log.error("processing failed!", (Throwable)e);
            throw (Throwable)e;
        }
    }

    private final ApiOptions convertOptions(Map<String, ?> processorOptions) {
        MappingReader reader = new MappingReader();
        MappingConverter converter = new MappingConverter();
        MappingVersion mapping = null;
        if (processorOptions.containsKey("mapping")) {
            mapping = reader.read(String.valueOf(processorOptions.get("mapping")));
        } else if (processorOptions.containsKey("typeMappings")) {
            mapping = reader.read(String.valueOf(processorOptions.get("typeMappings")));
            this.log.warn("'typeMappings' option is deprecated, use 'mapping'!");
        }
        ApiOptions options = new ApiOptions();
        options.setTargetDir(String.valueOf(processorOptions.get("targetDir")));
        if (processorOptions.containsKey("packageName")) {
            options.setPackageName(String.valueOf(processorOptions.get("packageName")));
            this.log.warn("'options:package-name' should be set in the mapping yaml!");
        }
        if (processorOptions.containsKey("beanValidation")) {
            Object obj = processorOptions.get("beanValidation");
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            options.setBeanValidation(((Boolean)obj).booleanValue());
            this.log.warn("options:bean-validation' should be set in the mapping yaml!");
        }
        if (mapping != null) {
            if (mapping instanceof Mapping) {
                options.setPackageName(((Mapping)mapping).getOptions().getPackageName());
                options.setBeanValidation(((Mapping)mapping).getOptions().getBeanValidation());
            } else if (mapping instanceof io.openapiprocessor.core.processor.mapping.v2.Mapping) {
                options.setPackageName(((io.openapiprocessor.core.processor.mapping.v2.Mapping)mapping).getOptions().getPackageName());
                options.setBeanValidation(((io.openapiprocessor.core.processor.mapping.v2.Mapping)mapping).getOptions().getBeanValidation());
                options.setJavadoc(((io.openapiprocessor.core.processor.mapping.v2.Mapping)mapping).getOptions().getJavadoc());
            }
            if (StringsKt.contains$default((CharSequence)options.getPackageName(), (CharSequence)"io.openapiprocessor.", (boolean)false, (int)2, null)) {
                this.log.warn("is 'options:package-name' set in mapping? found: '{}'.", (Object)options.getPackageName());
            }
            options.setTypeMappings(converter.convert(mapping));
        } else {
            this.log.warn("missing 'mapping.yaml' configuration!");
        }
        return options;
    }

    public SpringProcessor() {
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass.name)");
        this.log = logger;
    }
}

