/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.processor;

import io.openapiprocessor.core.framework.FrameworkAnnotation;
import io.openapiprocessor.core.framework.FrameworkAnnotations;
import io.openapiprocessor.core.model.HttpMethod;
import io.openapiprocessor.core.model.RequestBody;
import io.openapiprocessor.core.model.parameters.CookieParameter;
import io.openapiprocessor.core.model.parameters.HeaderParameter;
import io.openapiprocessor.core.model.parameters.MultipartParameter;
import io.openapiprocessor.core.model.parameters.Parameter;
import io.openapiprocessor.core.model.parameters.PathParameter;
import io.openapiprocessor.spring.model.parameters.QueryParameter;
import io.openapiprocessor.spring.processor.SpringFrameworkAnnotationsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/openapiprocessor/spring/processor/SpringFrameworkAnnotations;", "Lio/openapiprocessor/core/framework/FrameworkAnnotations;", "()V", "log", "Lorg/slf4j/Logger;", "getAnnotation", "Lio/openapiprocessor/core/framework/FrameworkAnnotation;", "httpMethod", "Lio/openapiprocessor/core/model/HttpMethod;", "parameter", "Lio/openapiprocessor/core/model/parameters/Parameter;", "key", "", "openapi-processor-spring"})
public final class SpringFrameworkAnnotations
implements FrameworkAnnotations {
    private final Logger log;

    @NotNull
    public FrameworkAnnotation getAnnotation(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        Object v = SpringFrameworkAnnotationsKt.access$getMAPPING_ANNOTATIONS$p().get(httpMethod);
        Intrinsics.checkNotNull(v);
        return (FrameworkAnnotation)v;
    }

    @NotNull
    public FrameworkAnnotation getAnnotation(@NotNull Parameter parameter) {
        FrameworkAnnotation frameworkAnnotation;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Parameter parameter2 = parameter;
        if (parameter2 instanceof RequestBody) {
            frameworkAnnotation = this.getAnnotation("body");
        } else if (parameter2 instanceof PathParameter) {
            frameworkAnnotation = this.getAnnotation("path");
        } else if (parameter2 instanceof QueryParameter) {
            frameworkAnnotation = this.getAnnotation("query");
        } else if (parameter2 instanceof HeaderParameter) {
            frameworkAnnotation = this.getAnnotation("header");
        } else if (parameter2 instanceof CookieParameter) {
            frameworkAnnotation = this.getAnnotation("cookie");
        } else if (parameter2 instanceof MultipartParameter) {
            frameworkAnnotation = this.getAnnotation("multipart");
        } else {
            this.log.error("unknown parameter type: " + parameter.getClass().getName());
            frameworkAnnotation = SpringFrameworkAnnotationsKt.access$getUNKNOWN_ANNOTATION$p();
        }
        return frameworkAnnotation;
    }

    private final FrameworkAnnotation getAnnotation(String key) {
        Object v = SpringFrameworkAnnotationsKt.access$getPARAMETER_ANNOTATIONS$p().get(key);
        Intrinsics.checkNotNull(v);
        return (FrameworkAnnotation)v;
    }

    public SpringFrameworkAnnotations() {
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass.name)");
        this.log = logger;
    }
}

