/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.maven;

import java.io.File;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public class UpToDateCheck {
    public boolean isUpToDate(File input, File output) {
        long lastModifiedOutput;
        long lastModifiedInput = this.getLastModified(input, this.scanInput(input));
        return lastModifiedInput <= (lastModifiedOutput = this.getLastModified(output, this.scanOutput(output)));
    }

    private String[] scanInput(File source) {
        DirectoryScanner sourceScanner = new DirectoryScanner();
        sourceScanner.setBasedir(source);
        sourceScanner.setIncludes(new String[]{"**/*.yaml", "**/*.yml"});
        sourceScanner.scan();
        return sourceScanner.getIncludedFiles();
    }

    private String[] scanOutput(File output) {
        if (!output.exists()) {
            return new String[0];
        }
        DirectoryScanner targetScanner = new DirectoryScanner();
        targetScanner.setBasedir(output);
        targetScanner.setIncludes(new String[]{"**/*", "**/*"});
        targetScanner.scan();
        return targetScanner.getIncludedFiles();
    }

    private long getLastModified(File root, String[] files) {
        long lastModified = 0L;
        for (String file : files) {
            File current = new File(root, file);
            if (!current.exists() || current.lastModified() <= lastModified) continue;
            lastModified = current.lastModified();
        }
        return lastModified;
    }
}

