/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.model.v30;

import io.openapiparser.Context;
import io.openapiparser.Keywords;
import io.openapiparser.Properties;
import io.openapiparser.model.v30.Extensions;
import io.openapiparser.model.v30.Operation;
import io.openapiparser.model.v30.Parameter;
import io.openapiparser.model.v30.Reference;
import io.openapiparser.model.v30.Server;
import io.openapiprocessor.jsonschema.schema.Bucket;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PathItem
extends Properties
implements Reference,
Extensions {
    public PathItem(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        super(context, bucket);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRef() {
        return this.hasProperty("$ref");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getRef() {
        return this.getStringOrThrow("$ref");
    }

    public @UnknownKeyFor @NonNull @Initialized PathItem getRefObject() {
        return this.getRefObjectOrThrow(PathItem.class);
    }

    public @Nullable @UnknownKeyFor @Initialized String getSummary() {
        return this.getStringOrNull("summary");
    }

    public @Nullable @UnknownKeyFor @Initialized String getDescription() {
        return this.getStringOrNull("description");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getGet() {
        return this.getOperation("get");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getPut() {
        return this.getOperation("put");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getPost() {
        return this.getOperation("post");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getDelete() {
        return this.getOperation("delete");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getOptions() {
        return this.getOperation("options");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getHead() {
        return this.getOperation("head");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getPatch() {
        return this.getOperation("patch");
    }

    public @Nullable @UnknownKeyFor @Initialized Operation getTrace() {
        return this.getOperation("trace");
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Operation> getOperations() {
        LinkedHashMap operations = new LinkedHashMap();
        this.bucket.forEach((operation, value) -> {
            if (Keywords.OPERATIONS.contains(operation)) {
                operations.put(operation, this.getOperation((String)operation));
            }
        });
        return Collections.unmodifiableMap(operations);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Server> getServers() {
        return this.getObjectsOrEmpty("servers", Server.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Parameter> getParameters() {
        return this.getObjectsOrEmpty("parameters", Parameter.class);
    }

    private @Nullable @UnknownKeyFor @Initialized Operation getOperation(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.getObjectOrNull(property, Operation.class);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getExtensions() {
        return super.getExtensions();
    }
}

