/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser;

import io.openapiparser.Context;
import io.openapiparser.OpenApiBundler;
import io.openapiparser.OpenApiResult;
import io.openapiparser.OpenApiSchemas;
import io.openapiparser.ValidationError;
import io.openapiparser.model.v31.OpenApi;
import io.openapiprocessor.jsonschema.ouput.OutputConverter;
import io.openapiprocessor.jsonschema.ouput.OutputUnit;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Output;
import io.openapiprocessor.jsonschema.schema.SchemaStore;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OpenApiResult31
implements OpenApiResult {
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized Bucket root;
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents;
    private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationError> validationErrors;

    public OpenApiResult31(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Bucket root, @UnknownKeyFor @NonNull @Initialized DocumentStore documents) {
        this.context = context;
        this.root = root;
        this.documents = documents;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized OpenApiResult.Version getVersion() {
        return OpenApiResult.Version.V31;
    }

    @Override
    public <T> T getModel(@UnknownKeyFor @NonNull @Initialized Class<T> api) {
        if (!OpenApi.class.equals(api)) {
            throw new IllegalArgumentException();
        }
        return (T)new OpenApi(this.context, this.root);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean validate(@UnknownKeyFor @NonNull @Initialized Validator validator, @UnknownKeyFor @NonNull @Initialized SchemaStore schemaStore) {
        try {
            schemaStore.register(OpenApiSchemas.OPENAPI_SCHEMA_31_ID, OpenApiSchemas.OPENAPI_SCHEMA_31);
            JsonSchema schema = schemaStore.getSchema(OpenApiSchemas.OPENAPI_SCHEMA_31_ID, SchemaVersion.Draft202012);
            Object bundle = this.bundle();
            JsonInstance instance = new JsonInstance(bundle);
            ValidationStep result = validator.validate(schema, instance);
            OutputConverter converter = new OutputConverter(Output.BASIC);
            OutputUnit output = converter.convert(result);
            if (output.isValid()) {
                this.validationErrors = Collections.emptyList();
                return true;
            }
            Collection errors = output.getErrors();
            assert (errors != null);
            this.validationErrors = errors.stream().map(e -> new ValidationError(e.getInstanceLocation(), e.getKeywordLocation(), e.getAbsoluteKeywordLocation(), e.getError())).collect(Collectors.toList());
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    @UnknownKeyFor @NonNull @Initialized Object bundle() {
        return new OpenApiBundler(this.context, this.documents, this.root).bundle();
    }
}

