/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.support;

import io.openapiprocessor.jsonschema.validator.support.IpV4Validator;
import io.openapiprocessor.jsonschema.validator.support.IpV6Validator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class EmailValidator {
    @UnknownKeyFor @NonNull @Initialized String email;
    private static final @UnknownKeyFor @NonNull @Initialized int DOUBLE_QUOTE = 34;
    private static final @UnknownKeyFor @NonNull @Initialized int AT = 64;
    private static final @UnknownKeyFor @NonNull @Initialized int OPEN_BRACKET = 91;
    private static final @UnknownKeyFor @NonNull @Initialized int BACK_SLASH = 92;
    private static final @UnknownKeyFor @NonNull @Initialized int CLOSE_BRACKET = 93;

    public EmailValidator(@UnknownKeyFor @NonNull @Initialized String email) {
        this.email = email;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean validate() {
        int endLocalPart = this.findLocalPart();
        if (endLocalPart < 0) {
            return false;
        }
        String localPart = this.email.substring(0, endLocalPart);
        String domain = this.email.substring(endLocalPart + 1);
        if (domain.isEmpty()) {
            return false;
        }
        boolean validLocalPart = this.validateLocalPart(localPart);
        boolean validDomain = this.validateDomain(domain);
        return validLocalPart && validDomain;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean validateLocalPart(@UnknownKeyFor @NonNull @Initialized String localPart) {
        boolean quoted;
        int length = localPart.length();
        char cStart = localPart.charAt(0);
        char cEnd = localPart.charAt(length - 1);
        boolean bl = quoted = cStart == '\"' && cEnd == '\"';
        if (quoted && length < 2) {
            return false;
        }
        String source = localPart;
        if (quoted) {
            source = localPart.substring(1, length - 2);
        }
        if (source.isEmpty()) {
            return true;
        }
        if (quoted) {
            return this.isQuotedString(source);
        }
        return this.isDotString(source);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean validateDomain(@UnknownKeyFor @NonNull @Initialized String domain) {
        boolean address;
        int length = domain.length();
        char cStart = domain.charAt(0);
        char cEnd = domain.charAt(length - 1);
        boolean bl = address = cStart == '[' && cEnd == ']';
        if (address && length < 2) {
            return false;
        }
        String source = domain;
        if (address) {
            source = domain.substring(1, length - 1);
            boolean ipv4 = new IpV4Validator(source).validate();
            if (ipv4) {
                return true;
            }
            boolean ipv6Tag = source.startsWith("IPv6:");
            if (!ipv6Tag) {
                return false;
            }
            String ipv6Source = source.substring("IPv6:".length());
            boolean ipv6 = new IpV6Validator(ipv6Source).validate();
            return ipv6;
        }
        return this.isDomain(source);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isDomain(@UnknownKeyFor @NonNull @Initialized String source) {
        String[] bytes;
        for (String part : bytes = source.split("\\.")) {
            int c = part.codePointAt(0);
            int l = part.codePointAt(part.length() - 1);
            if (!this.isLetter(c) && !this.isNumber(c)) {
                return false;
            }
            if (!this.isLetter(l) && !this.isNumber(l)) {
                return false;
            }
            for (int i = 1; i < part.length() - 1; ++i) {
                int mc = part.codePointAt(i);
                if (this.isLetter(mc) || this.isNumber(mc) || mc == 45) continue;
                return false;
            }
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized int findLocalPart() {
        boolean quoted = this.email.startsWith("\"");
        String stopOn = quoted ? "\"@" : "@";
        int stop = this.email.lastIndexOf(stopOn);
        if (stop < 0) {
            return stop;
        }
        return stop + (quoted ? 1 : 0);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isDotString(@UnknownKeyFor @NonNull @Initialized String source) {
        String[] bytes;
        if (source.startsWith(".") || source.endsWith(".")) {
            return false;
        }
        if (source.contains("..")) {
            return false;
        }
        for (String part : bytes = source.split("\\.")) {
            if (part.codePoints().allMatch(c -> this.isAtom((char)c))) continue;
            return false;
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isQuotedString(@UnknownKeyFor @NonNull @Initialized String source) {
        for (int i = 0; i < source.length(); ++i) {
            if (this.isQContent(source, i)) continue;
            return false;
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isQContent(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized int pos) {
        return this.isQText(source, pos) || this.isQPair(source, pos);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isAtom(@UnknownKeyFor @NonNull @Initialized char c) {
        return this.isAText(c);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isAText(@UnknownKeyFor @NonNull @Initialized char c) {
        return this.isLetter(c) || this.isNumber(c) || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\'' || c == '*' || c == '+' || c == '-' || c == '/' || c == '=' || c == '?' || c == '^' || c == '_' || c == '`' || c == '{' || c == '|' || c == '}' || c == '~';
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isQText(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized int pos) {
        char c = source.charAt(pos);
        return c >= ' ' && c <= '!' || c >= '#' && c <= '[' || c >= ']' && c <= '~';
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isQPair(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized int pos) {
        char c = source.charAt(pos);
        char e = source.charAt(pos);
        return c == '\\' && e >= ' ' && e <= '~';
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNumber(@UnknownKeyFor @NonNull @Initialized int c) {
        return c >= 48 && c <= 57;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isLetter(@UnknownKeyFor @NonNull @Initialized int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }
}

