/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.UuidStep;
import java.util.UUID;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Uuid {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public Uuid(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Format format = Format.of(schema.getFormat());
        if (format == null || !this.supportsFormat(format)) {
            return;
        }
        UuidStep step = new UuidStep(schema, instance);
        parentStep.add(step);
        if (!this.shouldValidate(schema)) {
            return;
        }
        String instanceValue = this.getInstanceValue(instance);
        boolean valid = this.isUuid(instanceValue);
        if (!valid) {
            step.setInvalid();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        boolean shouldAssert = schema.getContext().getVocabularies().requiresFormatAssertion();
        if (!shouldAssert) {
            shouldAssert = this.settings.assertFormat();
        }
        return shouldAssert;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean supportsFormat(@UnknownKeyFor @NonNull @Initialized Format format) {
        return Format.UUID.equals((Object)format);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asString());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isUuid(@UnknownKeyFor @NonNull @Initialized String uuid) {
        try {
            UUID.fromString(uuid);
            return uuid.length() == 36;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

