/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.MinLengthStep;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MinLength {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        boolean valid;
        Integer minLength = schema.getMinLength();
        if (minLength == null) {
            return;
        }
        MinLengthStep step = new MinLengthStep(schema, instance);
        String instanceValue = this.getInstanceValue(instance);
        boolean bl = valid = instanceValue.codePointCount(0, instanceValue.length()) >= minLength;
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asString());
    }
}

