/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.object;

import io.openapiprocessor.jsonschema.schema.DynamicScope;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.Validator;
import io.openapiprocessor.jsonschema.validator.object.PropertyNamesStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.HashSet;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PropertyNames {
    private final @UnknownKeyFor @NonNull @Initialized Validator validator;

    public PropertyNames(@UnknownKeyFor @NonNull @Initialized Validator validator) {
        this.validator = validator;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized DynamicScope dynamicScope, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        JsonSchema propertyNames = schema.getPropertyNames();
        if (propertyNames == null || !instance.isObject()) {
            return;
        }
        PropertyNamesStep step = new PropertyNamesStep(schema, instance);
        Map<String, Object> instanceObject = Null.nonNull(instance.asObject());
        HashSet<String> instanceProperties = new HashSet<String>(instanceObject.keySet());
        for (String instanceProperty : instanceProperties) {
            JsonInstance propertyName = instance.getPropertyName(instanceProperty);
            this.validator.validate(propertyNames, propertyName, dynamicScope, step);
        }
        parentStep.add(step);
    }
}

